/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.MeshAddressed;
import swim.runtime.PartAddress;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class MeshAddress
implements EdgeAddressed,
MeshAddressed,
Debug {
    final String edgeName;
    final Uri meshUri;
    private static int hashSeed;

    public MeshAddress(String edgeName, Uri meshUri) {
        this.edgeName = edgeName;
        this.meshUri = meshUri;
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    @Override
    public Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public MeshAddress meshUri(Uri meshUri) {
        return this.copy(this.edgeName, meshUri);
    }

    @Override
    public MeshAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    MeshAddress copy(String edgeName, Uri meshUri) {
        return new MeshAddress(edgeName, meshUri);
    }

    @Override
    public PartAddress partKey(Value partKey) {
        return new PartAddress(this.edgeName, this.meshUri, partKey);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MeshAddress) {
            MeshAddress that = (MeshAddress)other;
            return this.edgeName.equals(that.edgeName) && this.meshUri.equals((Object)that.meshUri);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(MeshAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()), (int)this.meshUri.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MeshAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(", ").debug((Object)this.meshUri.toString()).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MeshAddress from(String edgeName, Uri meshUri) {
        return new MeshAddress(edgeName, meshUri);
    }

    public static MeshAddress from(String edgeName, String meshUri) {
        return new MeshAddress(edgeName, Uri.parse((String)meshUri));
    }
}

