/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.HostAddress;
import swim.runtime.MeshAddressed;
import swim.runtime.PartAddressed;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class PartAddress
implements EdgeAddressed,
MeshAddressed,
PartAddressed,
Debug {
    final String edgeName;
    final Uri meshUri;
    final Value partKey;
    private static int hashSeed;

    public PartAddress(String edgeName, Uri meshUri, Value partKey) {
        this.edgeName = edgeName;
        this.meshUri = meshUri;
        this.partKey = partKey.commit();
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    @Override
    public Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public PartAddress meshUri(Uri meshUri) {
        return this.copy(this.edgeName, meshUri, this.partKey);
    }

    @Override
    public PartAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    @Override
    public Value partKey() {
        return this.partKey;
    }

    @Override
    public PartAddress partKey(Value partKey) {
        return this.copy(this.edgeName, this.meshUri, partKey);
    }

    PartAddress copy(String edgeName, Uri meshUri, Value partKey) {
        return new PartAddress(edgeName, meshUri, partKey);
    }

    @Override
    public HostAddress hostUri(Uri hostUri) {
        return new HostAddress(this.edgeName, this.meshUri, this.partKey, hostUri);
    }

    @Override
    public HostAddress hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PartAddress) {
            PartAddress that = (PartAddress)other;
            return this.edgeName.equals(that.edgeName) && this.meshUri.equals((Object)that.meshUri) && this.partKey.equals((Object)that.partKey);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(PartAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()), (int)this.meshUri.hashCode()), (int)this.partKey.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("PartAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(", ").debug((Object)this.meshUri.toString()).write(", ").debug((Object)this.partKey).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static PartAddress from(String edgeName, Uri meshUri, Value partKey) {
        return new PartAddress(edgeName, meshUri, partKey);
    }

    public static PartAddress from(String edgeName, String meshUri, Value partKey) {
        return new PartAddress(edgeName, Uri.parse((String)meshUri), partKey);
    }
}

