/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.AndPartPredicate;
import swim.runtime.AnyPartPredicate;
import swim.runtime.HashPartPredicate;
import swim.runtime.NodePartPredicate;
import swim.runtime.OrPartPredicate;
import swim.runtime.PartPredicateForm;
import swim.structure.Extant;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.structure.operator.AndOperator;
import swim.structure.operator.OrOperator;
import swim.uri.Uri;
import swim.uri.UriPattern;

public abstract class PartPredicate {
    private static Form<PartPredicate> form;
    private static PartPredicate any;

    protected PartPredicate() {
    }

    @Kind
    public static Form<PartPredicate> form() {
        if (form == null) {
            form = new PartPredicateForm();
        }
        return form;
    }

    public static PartPredicate any() {
        if (any == null) {
            any = new AnyPartPredicate();
        }
        return any;
    }

    public static PartPredicate or(PartPredicate ... predicates) {
        return new OrPartPredicate(predicates);
    }

    public static PartPredicate and(PartPredicate ... predicates) {
        return new AndPartPredicate(predicates);
    }

    public static PartPredicate node(UriPattern nodePattern) {
        return new NodePartPredicate(nodePattern);
    }

    public static PartPredicate node(String nodePattern) {
        return new NodePartPredicate(UriPattern.parse((String)nodePattern));
    }

    public static PartPredicate hash(int lowerBound, int upperBound) {
        return new HashPartPredicate(lowerBound, upperBound);
    }

    public static PartPredicate fromValue(Value value) {
        String tag = value.tag();
        if ("node".equals(tag)) {
            return NodePartPredicate.fromValue(value);
        }
        if ("hash".equals(tag)) {
            return HashPartPredicate.fromValue(value);
        }
        if (value instanceof OrOperator) {
            PartPredicate lhs = PartPredicate.fromValue(((OrOperator)value).operand1().toValue());
            PartPredicate rhs = PartPredicate.fromValue(((OrOperator)value).operand2().toValue());
            if (lhs != null && rhs != null) {
                return new OrPartPredicate(lhs, rhs);
            }
        } else if (value instanceof AndOperator) {
            PartPredicate lhs = PartPredicate.fromValue(((AndOperator)value).operand1().toValue());
            PartPredicate rhs = PartPredicate.fromValue(((AndOperator)value).operand2().toValue());
            if (lhs != null && rhs != null) {
                return new AndPartPredicate(lhs, rhs);
            }
        } else if (value instanceof Extant) {
            return PartPredicate.any();
        }
        return null;
    }

    public abstract boolean test(Uri var1, int var2);

    public boolean test(Uri nodeUri) {
        return this.test(nodeUri, nodeUri.hashCode());
    }

    public PartPredicate or(PartPredicate that) {
        return new OrPartPredicate(this, that);
    }

    public PartPredicate and(PartPredicate that) {
        return new AndPartPredicate(this, that);
    }

    public abstract Value toValue();
}

