/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.CellAddress;
import swim.util.Murmur3;

public final class ServiceAddress
implements CellAddress,
Debug {
    final String serviceName;
    private static int hashSeed;

    public ServiceAddress(String serviceName) {
        this.serviceName = serviceName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public ServiceAddress serviceName(String serviceName) {
        return this.copy(serviceName);
    }

    ServiceAddress copy(String serviceName) {
        return new ServiceAddress(serviceName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceAddress) {
            ServiceAddress that = (ServiceAddress)other;
            return this.serviceName.equals(that.serviceName);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(ServiceAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.serviceName.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("ServiceAddress").write(46).write("from").write(40).debug((Object)this.serviceName).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ServiceAddress from(String serviceName) {
        return new ServiceAddress(serviceName);
    }
}

