/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.CellAddress;
import swim.util.Murmur3;

public final class StoreAddress
implements CellAddress,
Debug {
    final String storeName;
    private static int hashSeed;

    public StoreAddress(String storeName) {
        this.storeName = storeName;
    }

    public String storeName() {
        return this.storeName;
    }

    public StoreAddress storeName(String storeName) {
        return this.copy(storeName);
    }

    StoreAddress copy(String storeName) {
        return new StoreAddress(storeName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StoreAddress) {
            StoreAddress that = (StoreAddress)other;
            return this.storeName.equals(that.storeName);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(StoreAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.storeName.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("StoreAddress").write(46).write("from").write(40).debug((Object)this.storeName).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static StoreAddress from(String storeName) {
        return new StoreAddress(storeName);
    }
}

