/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.concurrent.Conts;
import swim.runtime.agent.AgentModel;
import swim.runtime.agent.AgentView;

abstract class AgentModelCallback
implements Runnable {
    final AgentModel model;

    AgentModelCallback(AgentModel model) {
        this.model = model;
    }

    @Override
    public final void run() {
        long t0 = System.nanoTime();
        Object views = this.model.views;
        if (views instanceof AgentView) {
            try {
                this.call((AgentView)views);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    ((AgentView)views).didFail(error);
                }
                throw error;
            }
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    this.call(viewArray[i]);
                    continue;
                }
                catch (Throwable error) {
                    if (Conts.isNonFatal((Throwable)error)) {
                        viewArray[i].didFail(error);
                        continue;
                    }
                    throw error;
                }
            }
        }
        long dt = System.nanoTime() - t0;
        this.model.accumulateExecTime(dt);
    }

    abstract void call(AgentView var1);
}

