/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.concurrent.Conts;
import swim.runtime.LaneBinding;
import swim.runtime.LaneModel;
import swim.runtime.NodeException;
import swim.runtime.Push;
import swim.runtime.agent.AgentNode;
import swim.uri.Uri;

final class AgentModelPushUp
implements Runnable {
    final AgentNode node;
    final Push<?> push;

    AgentModelPushUp(AgentNode node, Push<?> push) {
        this.node = node;
        this.push = push;
    }

    @Override
    public void run() {
        try {
            Uri laneUri = this.push.laneUri();
            LaneBinding laneBinding = this.node.getLane(laneUri);
            if (laneBinding != null) {
                long t0 = System.nanoTime();
                laneBinding.pushUp(this.push);
                long dt = System.nanoTime() - t0;
                if (laneBinding instanceof LaneModel) {
                    ((LaneModel)laneBinding).accumulateExecTime(dt);
                }
            } else {
                this.push.trap(new NodeException("unknown lane: " + laneUri));
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.node.didFail(error);
            }
            throw error;
        }
    }
}

