/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Identity;
import swim.api.http.HttpLane;
import swim.api.lane.CommandLane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.JoinMapLane;
import swim.api.lane.JoinValueLane;
import swim.api.lane.LaneFactory;
import swim.api.lane.ListLane;
import swim.api.lane.MapLane;
import swim.api.lane.SpatialLane;
import swim.api.lane.SupplyLane;
import swim.api.lane.ValueLane;
import swim.api.policy.Policy;
import swim.api.ws.WsLane;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.Call;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.Task;
import swim.concurrent.TaskContext;
import swim.concurrent.TaskFunction;
import swim.concurrent.TaskRef;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.CellContext;
import swim.runtime.HostBinding;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LaneView;
import swim.runtime.LinkBinding;
import swim.runtime.Metric;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.NodeException;
import swim.runtime.Push;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.WarpBinding;
import swim.runtime.agent.AgentLane;
import swim.runtime.agent.AgentTimer;
import swim.runtime.http.RestLaneView;
import swim.runtime.lane.CommandLaneView;
import swim.runtime.lane.DemandLaneView;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.lane.JoinMapLaneView;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.ListLaneView;
import swim.runtime.lane.MapLaneView;
import swim.runtime.lane.SpatialLaneView;
import swim.runtime.lane.SupplyLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.spatial.GeoProjection;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;
import swim.uri.UriScheme;

public class AgentNode
extends AbstractTierBinding
implements NodeBinding,
CellContext,
LaneFactory,
Schedule,
Stage,
Task {
    final ConcurrentLinkedQueue<Runnable> mailbox;
    final long createdTime;
    protected NodeContext nodeContext;
    protected TaskContext taskContext;
    volatile HashTrieMap<Uri, LaneBinding> lanes = HashTrieMap.empty();
    static final Uri LANES_URI = Uri.parse((String)"lanes");
    static final AtomicReferenceFieldUpdater<AgentNode, HashTrieMap<Uri, LaneBinding>> LANES = AtomicReferenceFieldUpdater.newUpdater(AgentNode.class, HashTrieMap.class, "lanes");

    public AgentNode() {
        this.mailbox = new ConcurrentLinkedQueue();
        this.createdTime = System.currentTimeMillis();
    }

    protected static Uri normalizezLaneUri(Uri laneUri) {
        if (laneUri.query().isDefined() || laneUri.fragment().isDefined()) {
            laneUri = Uri.from((UriScheme)laneUri.scheme(), (UriAuthority)laneUri.authority(), (UriPath)laneUri.path());
        }
        return laneUri;
    }

    @Override
    public final TierContext tierContext() {
        return this.nodeContext;
    }

    @Override
    public final HostBinding host() {
        return this.nodeContext.host();
    }

    @Override
    public final NodeBinding nodeWrapper() {
        return this;
    }

    @Override
    public final NodeContext nodeContext() {
        return this.nodeContext;
    }

    @Override
    public void setNodeContext(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        nodeContext.stage().task((TaskFunction)this);
    }

    @Override
    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.nodeContext.unwrapNode(nodeClass);
    }

    @Override
    public <T> T bottomNode(Class<T> nodeClass) {
        Object node = this.nodeContext.bottomNode(nodeClass);
        if (node == null && nodeClass.isAssignableFrom(this.getClass())) {
            node = this;
        }
        return node;
    }

    public final TaskContext taskContext() {
        return this.taskContext;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    protected LaneContext createLaneContext(LaneAddress laneAddress, LaneBinding lane) {
        return new AgentLane(this, lane, laneAddress);
    }

    @Override
    public NodeAddress cellAddress() {
        return this.nodeContext.cellAddress();
    }

    @Override
    public final String edgeName() {
        return this.nodeContext.edgeName();
    }

    @Override
    public final Uri meshUri() {
        return this.nodeContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.nodeContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.nodeContext.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeContext.nodeUri();
    }

    @Override
    public long createdTime() {
        return this.createdTime;
    }

    public final Identity identity() {
        return this.nodeContext.identity();
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.nodeContext.openMetaNode(node, metaNode);
    }

    @Override
    public void openLanes(NodeBinding node) {
        this.nodeContext.openLanes(node);
    }

    @Override
    public FingerTrieSeq<Value> agentIds() {
        return FingerTrieSeq.empty();
    }

    @Override
    public FingerTrieSeq<Agent> agents() {
        return FingerTrieSeq.empty();
    }

    @Override
    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.nodeContext.createAgentFactory(node, agentDef);
    }

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.nodeContext.createAgentFactory(node, agentClass);
    }

    @Override
    public void openAgents(NodeBinding node) {
        this.nodeContext.openAgents(node);
    }

    @Override
    public HashTrieMap<Uri, LaneBinding> lanes() {
        return this.lanes;
    }

    @Override
    public LaneBinding getLane(Uri laneUri) {
        laneUri = AgentNode.normalizezLaneUri(laneUri);
        return (LaneBinding)this.lanes.get((Object)laneUri);
    }

    public LaneBinding openLaneView(Uri laneUri, LaneView laneView) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizezLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            if ((oldLanes = this.lanes).containsKey((Object)laneUri)) {
                laneBinding = (LaneBinding)oldLanes.get((Object)laneUri);
                newLanes = oldLanes;
                break;
            }
            if (laneBinding != null) continue;
            LaneAddress laneAddress = this.cellAddress().laneUri(laneUri);
            laneBinding = this.nodeContext.injectLane(laneAddress, laneView.createLaneBinding());
            LaneContext laneContext = this.createLaneContext(laneAddress, laneBinding);
            laneBinding.setLaneContext(laneContext);
            laneBinding = laneBinding.laneWrapper();
        } while (oldLanes != (newLanes = oldLanes.updated((Object)laneUri, (Object)laneBinding)) && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        laneBinding.openLaneView(laneView);
        if (oldLanes != newLanes) {
            this.activate(laneBinding);
            this.didOpenLane(laneBinding);
        }
        return laneBinding;
    }

    public LaneBinding openLane(Uri laneUri, Lane lane) {
        return this.openLaneView(laneUri, (LaneView)lane);
    }

    @Override
    public LaneBinding openLane(Uri laneUri) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizezLaneUri(laneUri);
        TierBinding laneBinding = null;
        do {
            LaneBinding lane;
            if ((lane = (LaneBinding)(oldLanes = this.lanes).get((Object)laneUri)) != null) {
                if (laneBinding != null) {
                    laneBinding.close();
                }
                laneBinding = lane;
                newLanes = oldLanes;
                break;
            }
            if (laneBinding == null) {
                LaneAddress laneAddress = this.cellAddress().laneUri(laneUri);
                laneBinding = this.nodeContext.createLane(laneAddress);
                if (laneBinding != null) {
                    laneBinding = this.nodeContext.injectLane(laneAddress, (LaneBinding)laneBinding);
                    LaneContext laneContext = this.createLaneContext(laneAddress, (LaneBinding)laneBinding);
                    laneBinding.setLaneContext(laneContext);
                    laneBinding = laneBinding.laneWrapper();
                    newLanes = oldLanes.updated((Object)laneUri, (Object)laneBinding);
                    continue;
                }
                newLanes = oldLanes;
                break;
            }
            newLanes = oldLanes.updated((Object)laneUri, (Object)laneBinding);
        } while (oldLanes != newLanes && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        if (laneBinding != null) {
            this.activate(laneBinding);
            this.didOpenLane((LaneBinding)laneBinding);
        }
        return laneBinding;
    }

    @Override
    public LaneBinding openLane(Uri laneUri, LaneBinding lane) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizezLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            if ((oldLanes = this.lanes).containsKey((Object)laneUri)) {
                laneBinding = null;
                newLanes = oldLanes;
                break;
            }
            if (laneBinding != null) continue;
            LaneAddress laneAddress = this.cellAddress().laneUri(laneUri);
            laneBinding = this.nodeContext.injectLane(laneAddress, lane);
            LaneContext laneContext = this.createLaneContext(laneAddress, laneBinding);
            laneBinding.setLaneContext(laneContext);
            laneBinding = laneBinding.laneWrapper();
        } while (oldLanes != (newLanes = oldLanes.updated((Object)laneUri, laneBinding)) && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        if (laneBinding != null) {
            this.activate(laneBinding);
            this.didOpenLane(laneBinding);
        }
        return laneBinding;
    }

    public void closeLane(Uri laneUri) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizezLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            LaneBinding lane;
            if ((lane = (LaneBinding)(oldLanes = this.lanes).get((Object)laneUri)) == null) {
                laneBinding = null;
                newLanes = oldLanes;
                break;
            }
            laneBinding = lane;
            newLanes = oldLanes.removed((Object)laneUri);
        } while (oldLanes != newLanes && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        if (laneBinding != null) {
            laneBinding.didClose();
            this.didCloseLane(laneBinding);
        }
    }

    protected void didOpenLane(LaneBinding lane) {
    }

    protected void didCloseLane(LaneBinding lane) {
    }

    public <V> CommandLane<V> commandLane() {
        return new CommandLaneView(null, null);
    }

    public <V> DemandLane<V> demandLane() {
        return new DemandLaneView(null, null);
    }

    public <K, V> DemandMapLane<K, V> demandMapLane() {
        return new DemandMapLaneView(null, null, null);
    }

    public <V> HttpLane<V> httpLane() {
        return new RestLaneView(null, null);
    }

    public <L, K, V> JoinMapLane<L, K, V> joinMapLane() {
        return new JoinMapLaneView(null, null, null, null);
    }

    public <K, V> JoinValueLane<K, V> joinValueLane() {
        return new JoinValueLaneView(null, null, null);
    }

    public <V> ListLane<V> listLane() {
        return new ListLaneView(null, null);
    }

    public <K, V> MapLane<K, V> mapLane() {
        return new MapLaneView(null, null, null);
    }

    public <K, S, V> SpatialLane<K, S, V> spatialLane(Z2Form<S> shapeForm) {
        return new SpatialLaneView(null, null, shapeForm, null);
    }

    public <K, V> SpatialLane<K, R2Shape, V> geospatialLane() {
        return new SpatialLaneView(null, null, GeoProjection.wgs84Form(), null);
    }

    public <V> SupplyLane<V> supplyLane() {
        return new SupplyLaneView(null, null);
    }

    public <V> ValueLane<V> valueLane() {
        return new ValueLaneView(null, null);
    }

    public <I, O> WsLane<I, O> wsLane() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.nodeContext.openMetaLane(lane, metaLane);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.nodeContext.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.nodeContext.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public void openUplink(LinkBinding link) {
        Uri laneUri = AgentNode.normalizezLaneUri(link.laneUri());
        LaneBinding laneBinding = this.getLane(laneUri);
        if (laneBinding != null) {
            laneBinding = laneBinding.bottomLane(LaneBinding.class);
        }
        if (laneBinding != null) {
            laneBinding.openUplink(link);
        } else if (link instanceof WarpBinding) {
            this.openUnknownUplink(laneUri, link);
        }
    }

    protected void openUnknownUplink(Uri laneUri, LinkBinding link) {
        UplinkError.rejectLaneNotFound(link);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        LinkBinding link = this.nodeContext.bindDownlink(downlink);
        link.setCellContext(this);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.nodeContext.openDownlink(link);
        link.setCellContext(this);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void pushUp(Push<?> push) {
        Uri laneUri = push.laneUri();
        LaneBinding laneBinding = this.getLane(laneUri);
        if (laneBinding != null) {
            laneBinding = laneBinding.bottomLane(LaneBinding.class);
        }
        if (laneBinding != null) {
            laneBinding.pushUp(push);
        } else {
            push.trap(new NodeException("unknown lane: " + laneUri));
        }
    }

    @Override
    public void pushDown(Push<?> push) {
        this.nodeContext.pushDown(push);
    }

    @Override
    public void reportDown(Metric metric) {
        this.nodeContext.reportDown(metric);
    }

    public void trace(Object message) {
        this.nodeContext.trace(message);
    }

    public void debug(Object message) {
        this.nodeContext.debug(message);
    }

    public void info(Object message) {
        this.nodeContext.info(message);
    }

    public void warn(Object message) {
        this.nodeContext.warn(message);
    }

    public void error(Object message) {
        this.nodeContext.error(message);
    }

    public void fail(Object message) {
        this.nodeContext.fail(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        if (Conts.isNonFatal((Throwable)error)) {
            this.fail(error);
        } else {
            error.printStackTrace();
        }
    }

    @Override
    public Policy policy() {
        return this.nodeContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this;
    }

    @Override
    public Stage stage() {
        return this;
    }

    public Stage asyncStage() {
        return this.nodeContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.nodeContext.store();
    }

    public TimerRef timer(TimerFunction timer) {
        Schedule schedule = this.nodeContext.schedule();
        AgentTimer agentTimer = new AgentTimer(this, timer);
        schedule.timer(timer);
        return agentTimer;
    }

    public TimerRef setTimer(long millis, TimerFunction timer) {
        Schedule schedule = this.nodeContext.schedule();
        AgentTimer agentTimer = new AgentTimer(this, timer);
        schedule.setTimer(millis, (TimerFunction)agentTimer);
        return agentTimer;
    }

    public TaskRef task(TaskFunction task) {
        return this.nodeContext.stage().task(task);
    }

    public <T> Call<T> call(Cont<T> future) {
        return this.nodeContext.stage().call(future);
    }

    public void execute(Runnable command) {
        this.mailbox.add(command);
        this.taskContext.cue();
    }

    public boolean taskWillBlock() {
        return false;
    }

    public void runTask() {
        Runnable command;
        while ((command = this.mailbox.poll()) != null) {
            try {
                command.run();
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
        }
    }

    public void taskWillCue() {
    }

    public void taskDidCancel() {
    }
}

