/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Timer;
import swim.concurrent.TimerContext;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.runtime.agent.AgentModel;
import swim.runtime.agent.AgentNode;

public class AgentTimer
implements Timer,
TimerContext,
TimerRef,
Runnable {
    protected final AgentNode node;
    protected final TimerFunction timer;
    protected TimerContext timerContext;

    public AgentTimer(AgentNode node, TimerFunction timer) {
        this.node = node;
        this.timer = timer;
    }

    public TimerContext timerContext() {
        return this.timerContext;
    }

    public void setTimerContext(TimerContext timerContext) {
        this.timerContext = timerContext;
        if (this.timer instanceof Timer) {
            ((Timer)this.timer).setTimerContext((TimerContext)this);
        }
    }

    public void runTimer() {
        this.node.execute(this);
    }

    public void timerWillSchedule(long millis) {
        if (this.timer instanceof Timer) {
            ((Timer)this.timer).timerWillSchedule(millis);
        }
    }

    public void timerDidCancel() {
        if (this.timer instanceof Timer) {
            ((Timer)this.timer).timerDidCancel();
        }
    }

    public Schedule schedule() {
        return this.node;
    }

    public boolean isScheduled() {
        return this.timerContext.isScheduled();
    }

    public void reschedule(long millis) {
        this.timerContext.reschedule(millis);
    }

    public boolean cancel() {
        return this.timerContext.cancel();
    }

    @Override
    public void run() {
        long t0 = System.nanoTime();
        try {
            this.timer.runTimer();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.node.didFail(error);
            }
            throw error;
        }
        long dt = System.nanoTime() - t0;
        if (this.node instanceof AgentModel) {
            AgentModel.TIMER_EVENT_DELTA.incrementAndGet((AgentModel)this.node);
            ((AgentModel)this.node).accumulateExecTime(dt);
        }
    }
}

