/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.api.DownlinkException;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.downlink.EventDownlink;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.api.warp.function.DidLink;
import swim.api.warp.function.DidReceive;
import swim.api.warp.function.DidSync;
import swim.api.warp.function.DidUnlink;
import swim.api.warp.function.OnEvent;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillLink;
import swim.api.warp.function.WillReceive;
import swim.api.warp.function.WillSync;
import swim.api.warp.function.WillUnlink;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.downlink.EventDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;

public class EventDownlinkView<V>
extends WarpDownlinkView
implements EventDownlink<V> {
    protected final Form<V> valueForm;
    protected EventDownlinkModel model;

    public EventDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Form<V> valueForm, Object observers) {
        super(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, flags, observers);
        this.valueForm = valueForm;
    }

    public EventDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, Form<V> valueForm) {
        this(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, 1, valueForm, null);
    }

    @Override
    public EventDownlinkModel downlinkModel() {
        return this.model;
    }

    @Override
    public EventDownlinkView<V> hostUri(Uri hostUri) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public EventDownlinkView<V> nodeUri(Uri nodeUri) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    @Override
    public EventDownlinkView<V> laneUri(Uri laneUri) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    @Override
    public EventDownlinkView<V> prio(float prio) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> rate(float rate) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> body(Value body) {
        return new EventDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public EventDownlinkView<V> keepLinked(boolean keepLinked) {
        this.flags = keepLinked ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    @Override
    public EventDownlinkView<V> keepSynced(boolean keepSynced) {
        this.flags = keepSynced ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        return this;
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> EventDownlinkView<V2> valueForm(Form<V2> valueForm) {
        return new EventDownlinkView<V2>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> EventDownlinkView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    @Override
    public EventDownlinkView<V> observe(Object observer) {
        return (EventDownlinkView)super.observe(observer);
    }

    @Override
    public EventDownlinkView<V> unobserve(Object observer) {
        return (EventDownlinkView)super.unobserve(observer);
    }

    public EventDownlinkView<V> onEvent(OnEvent<V> onEvent) {
        return this.observe(onEvent);
    }

    @Override
    public EventDownlinkView<V> willReceive(WillReceive willReceive) {
        return this.observe(willReceive);
    }

    @Override
    public EventDownlinkView<V> didReceive(DidReceive didReceive) {
        return this.observe(didReceive);
    }

    @Override
    public EventDownlinkView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public EventDownlinkView<V> willLink(WillLink willLink) {
        return this.observe(willLink);
    }

    @Override
    public EventDownlinkView<V> didLink(DidLink didLink) {
        return this.observe(didLink);
    }

    @Override
    public EventDownlinkView<V> willSync(WillSync willSync) {
        return this.observe(willSync);
    }

    @Override
    public EventDownlinkView<V> didSync(DidSync didSync) {
        return this.observe(didSync);
    }

    @Override
    public EventDownlinkView<V> willUnlink(WillUnlink willUnlink) {
        return this.observe(willUnlink);
    }

    @Override
    public EventDownlinkView<V> didUnlink(DidUnlink didUnlink) {
        return this.observe(didUnlink);
    }

    @Override
    public EventDownlinkView<V> didConnect(DidConnect didConnect) {
        return this.observe(didConnect);
    }

    @Override
    public EventDownlinkView<V> didDisconnect(DidDisconnect didDisconnect) {
        return this.observe(didDisconnect);
    }

    @Override
    public EventDownlinkView<V> didClose(DidClose didClose) {
        return this.observe(didClose);
    }

    @Override
    public EventDownlinkView<V> didFail(DidFail didFail) {
        return this.observe(didFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchOnEvent(V value, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof OnEvent) {
                if (((OnEvent)observers).isPreemptive() == preemptive) {
                    try {
                        ((OnEvent)observers).onEvent(value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof OnEvent)) continue;
                    if (((OnEvent)observer).isPreemptive() == preemptive) {
                        try {
                            ((OnEvent)observer).onEvent(value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public void downlinkOnEvent(V value) {
    }

    @Override
    public EventDownlinkModel createDownlinkModel() {
        return new EventDownlinkModel(this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public EventDownlinkView<V> open() {
        if (this.model == null) {
            LinkBinding linkBinding = this.cellContext.bindDownlink(this);
            if (linkBinding instanceof EventDownlinkModel) {
                this.model = (EventDownlinkModel)linkBinding;
                this.model.addDownlink(this);
            } else {
                throw new DownlinkException("downlink type mismatch");
            }
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        this.model = null;
    }
}

