/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.api.DownlinkException;
import swim.collections.STreeList;
import swim.runtime.DownlinkView;
import swim.runtime.Push;
import swim.runtime.downlink.ListDownlinkRelayClear;
import swim.runtime.downlink.ListDownlinkRelayDrop;
import swim.runtime.downlink.ListDownlinkRelayMove;
import swim.runtime.downlink.ListDownlinkRelayRemove;
import swim.runtime.downlink.ListDownlinkRelayTake;
import swim.runtime.downlink.ListDownlinkRelayUpdate;
import swim.runtime.downlink.ListDownlinkView;
import swim.runtime.warp.ListDownlinkModem;
import swim.runtime.warp.ListLinkDelta;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.EventMessage;

public class ListDownlinkModel
extends ListDownlinkModem<ListDownlinkView<?>> {
    protected static final int STATEFUL = 1;
    protected final STreeList<Value> state = STreeList.empty();
    protected int flags = 0;

    public ListDownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    public final boolean isStateful() {
        return (this.flags & 1) != 0;
    }

    public ListDownlinkModel isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof DownlinkView) {
            ((ListDownlinkView)views).didSetStateful(isStateful);
        } else if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ListDownlinkView)viewArray[i]).didSetStateful(isStateful);
            }
        }
        return this;
    }

    @Override
    protected void pushDownEvent(Push<EventMessage> push) {
        EventMessage message = push.message();
        this.onEvent(message);
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                Value value = payload.body();
                new ListDownlinkRelayUpdate(this, message, push.cont(), index, value, key).run();
            }
        } else if ("move".equals(tag)) {
            Value header = payload.header("move");
            int fromIndex = header.get("from").intValue(-1);
            int toIndex = header.get("to").intValue(-1);
            if (fromIndex > -1 && toIndex > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                new ListDownlinkRelayMove(this, message, push.cont(), fromIndex, toIndex, key).run();
            }
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                new ListDownlinkRelayRemove(this, message, push.cont(), index, key).run();
            }
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new ListDownlinkRelayDrop(this, message, push.cont(), lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new ListDownlinkRelayTake(this, message, push.cont(), upper).run();
        } else if ("clear".equals(tag)) {
            new ListDownlinkRelayClear(this, message, push.cont()).run();
        } else {
            push.trap((Throwable)new DownlinkException("unknown subcommand: " + payload));
        }
    }

    @Override
    protected void didAddDownlink(ListDownlinkView<?> view) {
        super.didAddDownlink(view);
        if (this.views instanceof DownlinkView) {
            this.isStateful(view.isStateful());
        }
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public int size() {
        return this.state.size();
    }

    public boolean contains(Object value) {
        if (value != null) {
            return this.state.contains(value);
        }
        return false;
    }

    public int indexOf(Object o) {
        return this.state.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.state.lastIndexOf(o);
    }

    public List<Value> subList(int fromIndex, int toIndex) {
        return this.state.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.state.toArray();
    }

    public <V> V[] toArray(V[] array) {
        return this.state.toArray((Object[])array);
    }

    public ListIterator<Map.Entry<Object, Value>> entryIterator() {
        return this.state.entryIterator();
    }

    public Iterator<Value> iterator() {
        return this.state.iterator();
    }

    public ListIterator<Value> listIterator() {
        return this.state.listIterator();
    }

    public ListIterator<Value> listIterator(int index) {
        return this.state.listIterator(index);
    }

    public ListIterator<Object> keyIterator() {
        return this.state.keyIterator();
    }

    public Map.Entry<Object, Value> getEntry(int index) {
        return this.state.getEntry(index);
    }

    public Map.Entry<Object, Value> getEntry(int index, Object key) {
        return this.state.getEntry(index, key);
    }

    public Value get(int index, Object key) {
        Value value = (Value)this.state.get(index, key);
        if (value != null) {
            return value;
        }
        return Value.absent();
    }

    public <V> boolean add(ListDownlinkView<V> view, int index, V newObject) {
        return this.add(view, index, newObject, null);
    }

    public <V> boolean add(ListDownlinkView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListDownlinkRelayUpdate relay = new ListDownlinkRelayUpdate(this, view.stage(), index, newValue, key);
        relay.valueForm = valueForm;
        relay.newObject = newObject;
        relay.run();
        if (relay.isDone() && relay.valueForm == valueForm) {
            return relay.oldObject != null;
        }
        return false;
    }

    public <V> V set(ListDownlinkView<V> view, int index, V newObject) {
        return this.set(view, index, newObject, null);
    }

    public <V> V set(ListDownlinkView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListDownlinkRelayUpdate relay = new ListDownlinkRelayUpdate(this, view.stage(), index, newValue, key);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.isDone() && relay.valueForm == valueForm) {
            return (V)relay.oldObject;
        }
        return null;
    }

    public <V> void move(ListDownlinkView<V> view, int fromIndex, int toIndex) {
        this.move(view, fromIndex, toIndex, null);
    }

    public <V> void move(ListDownlinkView<V> view, int fromIndex, int toIndex, Object key) {
        ListDownlinkRelayMove relay = new ListDownlinkRelayMove(this, view.stage(), fromIndex, toIndex, key);
        relay.run();
    }

    public <V> V remove(ListDownlinkView<V> view, int index) {
        return this.remove(view, index, null);
    }

    public <V> V remove(ListDownlinkView<V> view, int index, Object key) {
        Form valueForm = view.valueForm;
        Map.Entry<Object, Value> entry = this.getEntry(index, key);
        if (entry != null) {
            Object actualKey = key == null ? entry.getKey() : key;
            ListDownlinkRelayRemove relay = new ListDownlinkRelayRemove(this, view.stage(), index, actualKey);
            relay.valueForm = valueForm;
            relay.run();
            if (relay.isDone()) {
                if (relay.valueForm != valueForm && valueForm != null) {
                    relay.oldObject = valueForm.cast((Item)relay.oldValue);
                    if (relay.oldObject == null) {
                        relay.oldObject = valueForm.unit();
                    }
                }
                return (V)relay.oldObject;
            }
            return null;
        }
        return null;
    }

    public void drop(ListDownlinkView<?> view, int lower) {
        this.pushUp(ListLinkDelta.drop(lower));
    }

    public void take(ListDownlinkView<?> view, int upper) {
        this.pushUp(ListLinkDelta.take(upper));
    }

    public void clear(ListDownlinkView<?> view) {
        this.pushUp(ListLinkDelta.clear());
    }
}

