/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.runtime.warp.ListLinkDelta;
import swim.warp.EventMessage;

final class ListDownlinkRelayClear
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    final Cont<EventMessage> cont;

    ListDownlinkRelayClear(ListDownlinkModel model, EventMessage message, Cont<EventMessage> cont) {
        super(model, 0, 3, null);
        this.message = message;
        this.cont = cont;
    }

    ListDownlinkRelayClear(ListDownlinkModel model, Stage stage) {
        super(model, 3, 4, stage);
        this.message = null;
        this.cont = null;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2 && ((ListDownlinkModel)this.model).isStateful()) {
            ((ListDownlinkModel)this.model).state.clear();
        }
    }

    @Override
    protected boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.downlinkWillClear();
            }
            return view.dispatchWillClear(preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidClear();
            }
            return view.dispatchDidClear(preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            ((ListDownlinkModel)this.model).pushUp(ListLinkDelta.clear());
        }
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

