/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.runtime.warp.ListLinkDelta;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayUpdate
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    final Cont<EventMessage> cont;
    final int index;
    Object key;
    Form<Object> valueForm;
    Value oldValue;
    Value newValue;
    Object oldObject;
    Object newObject;

    ListDownlinkRelayUpdate(ListDownlinkModel model, EventMessage message, Cont<EventMessage> cont, int index, Value newValue, Object key) {
        super(model, 4);
        this.message = message;
        this.cont = cont;
        this.index = index;
        this.key = key;
        this.newValue = newValue;
    }

    ListDownlinkRelayUpdate(ListDownlinkModel model, Stage stage, int index, Value newValue, Object key) {
        super(model, 1, 3, stage);
        this.message = null;
        this.cont = null;
        this.index = index;
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            if (((ListDownlinkModel)this.model).isStateful()) {
                Map.Entry entry = this.index < ((ListDownlinkModel)this.model).state.size() ? ((ListDownlinkModel)this.model).state.getEntry(this.index, this.key) : null;
                if (entry == null) {
                    if (this.key == null) {
                        byte[] bytes = new byte[6];
                        ThreadLocalRandom.current().nextBytes(bytes);
                        this.key = Value.fromObject((Object)bytes);
                    }
                    ((ListDownlinkModel)this.model).state.add(this.index, (Object)this.newValue, this.key);
                } else {
                    this.oldValue = (Value)entry.getValue();
                    this.key = entry.getKey();
                    ((ListDownlinkModel)this.model).state.set(this.index, (Object)this.newValue, this.key);
                }
            }
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
        }
    }

    @Override
    protected boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Map.Entry<Boolean, Object> result;
            this.newValue = view.downlinkWillUpdateValue(this.index, this.newValue);
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                if (this.oldValue != null) {
                    this.oldObject = valueForm.cast((Item)this.oldValue);
                }
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
            }
            if (preemptive) {
                this.newObject = view.downlinkWillUpdate(this.index, this.newObject);
            }
            if (this.newObject != (result = view.dispatchWillUpdate(this.index, this.newObject, preemptive)).getValue()) {
                this.oldObject = this.newObject;
                this.newObject = result.getValue();
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            view.downlinkDidUpdateValue(this.index, this.newValue, this.oldValue);
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidUpdate(this.index, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.index, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            ((ListDownlinkModel)this.model).pushUp(ListLinkDelta.update(this.index, Value.fromObject((Object)this.key), this.newValue));
        }
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

