/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.api.DownlinkException;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.downlink.ListDownlink;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.api.warp.function.DidLink;
import swim.api.warp.function.DidReceive;
import swim.api.warp.function.DidSync;
import swim.api.warp.function.DidUnlink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillLink;
import swim.api.warp.function.WillReceive;
import swim.api.warp.function.WillSync;
import swim.api.warp.function.WillUnlink;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.observable.function.DidClear;
import swim.observable.function.DidDrop;
import swim.observable.function.DidMoveIndex;
import swim.observable.function.DidRemoveIndex;
import swim.observable.function.DidTake;
import swim.observable.function.DidUpdateIndex;
import swim.observable.function.WillClear;
import swim.observable.function.WillDrop;
import swim.observable.function.WillMoveIndex;
import swim.observable.function.WillRemoveIndex;
import swim.observable.function.WillTake;
import swim.observable.function.WillUpdateIndex;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkViewEntry;
import swim.runtime.downlink.ListDownlinkViewEntryIterator;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.collections.ValueIterator;
import swim.structure.collections.ValueList;
import swim.structure.collections.ValueListIterator;
import swim.uri.Uri;

public class ListDownlinkView<V>
extends WarpDownlinkView
implements ListDownlink<V> {
    protected static final int STATEFUL = 4;
    protected final Form<V> valueForm;
    protected ListDownlinkModel model;

    public ListDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Form<V> valueForm, Object observers) {
        super(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, flags, observers);
        this.valueForm = valueForm;
    }

    public ListDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, Form<V> valueForm) {
        this(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, 7, valueForm, null);
    }

    @Override
    public ListDownlinkModel downlinkModel() {
        return this.model;
    }

    @Override
    public ListDownlinkView<V> hostUri(Uri hostUri) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public ListDownlinkView<V> nodeUri(Uri nodeUri) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    @Override
    public ListDownlinkView<V> laneUri(Uri laneUri) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    @Override
    public ListDownlinkView<V> prio(float prio) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> rate(float rate) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> body(Value body) {
        return new ListDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ListDownlinkView<V> keepLinked(boolean keepLinked) {
        this.flags = keepLinked ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    @Override
    public ListDownlinkView<V> keepSynced(boolean keepSynced) {
        this.flags = keepSynced ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        return this;
    }

    public final boolean isStateful() {
        return (this.flags & 4) != 0;
    }

    public ListDownlinkView<V> isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        ListDownlinkModel model = this.model;
        if (model != null) {
            model.isStateful(isStateful);
        }
        return this;
    }

    void didSetStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ListDownlinkView<V2> valueForm(Form<V2> valueForm) {
        return new ListDownlinkView<V2>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> ListDownlinkView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    @Override
    public ListDownlinkView<V> observe(Object observer) {
        return (ListDownlinkView)super.observe(observer);
    }

    @Override
    public ListDownlinkView<V> unobserve(Object observer) {
        return (ListDownlinkView)super.unobserve(observer);
    }

    public ListDownlink<V> willMove(WillMoveIndex<V> willMove) {
        return this.observe(willMove);
    }

    public ListDownlink<V> didMove(DidMoveIndex<V> didMove) {
        return this.observe(didMove);
    }

    public ListDownlinkView<V> willUpdate(WillUpdateIndex<V> willUpdate) {
        return this.observe(willUpdate);
    }

    public ListDownlinkView<V> didUpdate(DidUpdateIndex<V> didUpdate) {
        return this.observe(didUpdate);
    }

    public ListDownlinkView<V> willRemove(WillRemoveIndex willRemove) {
        return this.observe(willRemove);
    }

    public ListDownlinkView<V> didRemove(DidRemoveIndex<V> didRemove) {
        return this.observe(didRemove);
    }

    public ListDownlinkView<V> willDrop(WillDrop willDrop) {
        return this.observe(willDrop);
    }

    public ListDownlinkView<V> didDrop(DidDrop didDrop) {
        return this.observe(didDrop);
    }

    public ListDownlinkView<V> willTake(WillTake willTake) {
        return this.observe(willTake);
    }

    public ListDownlinkView<V> didTake(DidTake didTake) {
        return this.observe(didTake);
    }

    public ListDownlinkView<V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public ListDownlinkView<V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public ListDownlinkView<V> willReceive(WillReceive willReceive) {
        return this.observe(willReceive);
    }

    @Override
    public ListDownlinkView<V> didReceive(DidReceive didReceive) {
        return this.observe(didReceive);
    }

    @Override
    public ListDownlinkView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public ListDownlinkView<V> willLink(WillLink willLink) {
        return this.observe(willLink);
    }

    @Override
    public ListDownlinkView<V> didLink(DidLink didLink) {
        return this.observe(didLink);
    }

    @Override
    public ListDownlinkView<V> willSync(WillSync willSync) {
        return this.observe(willSync);
    }

    @Override
    public ListDownlinkView<V> didSync(DidSync didSync) {
        return this.observe(didSync);
    }

    @Override
    public ListDownlinkView<V> willUnlink(WillUnlink willUnlink) {
        return this.observe(willUnlink);
    }

    @Override
    public ListDownlinkView<V> didUnlink(DidUnlink didUnlink) {
        return this.observe(didUnlink);
    }

    @Override
    public ListDownlinkView<V> didConnect(DidConnect didConnect) {
        return this.observe(didConnect);
    }

    @Override
    public ListDownlinkView<V> didDisconnect(DidDisconnect didDisconnect) {
        return this.observe(didDisconnect);
    }

    @Override
    public ListDownlinkView<V> didClose(DidClose didClose) {
        return this.observe(didClose);
    }

    @Override
    public ListDownlinkView<V> didFail(DidFail didFail) {
        return this.observe(didFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillUpdate(int index, V newValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUpdateIndex) {
                if (((WillUpdateIndex)observers).isPreemptive() == preemptive) {
                    try {
                        newValue = ((WillUpdateIndex)observers).willUpdate(index, newValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUpdateIndex)) continue;
                    if (((WillUpdateIndex)observer).isPreemptive() == preemptive) {
                        try {
                            newValue = ((WillUpdateIndex)observer).willUpdate(index, newValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUpdate(int index, V newValue, V oldValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUpdateIndex) {
                if (((DidUpdateIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUpdateIndex)observers).didUpdate(index, newValue, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUpdateIndex)) continue;
                    if (((DidUpdateIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUpdateIndex)observer).didUpdate(index, newValue, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillMove(int fromIndex, int toIndex, V value, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillMoveIndex) {
                if (((WillMoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillMoveIndex)observers).willMove(fromIndex, toIndex, value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillMoveIndex)) continue;
                    if (((WillMoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillMoveIndex)observer).willMove(fromIndex, toIndex, value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidMove(int fromIndex, int toIndex, V value, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidMoveIndex) {
                if (((DidMoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidMoveIndex)observers).didMove(fromIndex, toIndex, value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidMoveIndex)) continue;
                    if (((DidMoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidMoveIndex)observer).didMove(fromIndex, toIndex, value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillRemove(int index, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillRemoveIndex) {
                if (((WillRemoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillRemoveIndex)observers).willRemove(index);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillRemoveIndex)) continue;
                    if (((WillRemoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillRemoveIndex)observer).willRemove(index);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidRemove(int index, V oldValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidRemoveIndex) {
                if (((DidRemoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidRemoveIndex)observers).didRemove(index, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidRemoveIndex)) continue;
                    if (((DidRemoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidRemoveIndex)observer).didRemove(index, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillDrop(int lower, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillDrop) {
                if (((WillDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillDrop)observers).willDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillDrop)) continue;
                    if (((WillDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillDrop)observer).willDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidDrop(int lower, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidDrop) {
                if (((DidDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidDrop)observers).didDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidDrop)) continue;
                    if (((DidDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidDrop)observer).didDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillTake(int upper, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillTake) {
                if (((WillTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillTake)observers).willTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillTake)) continue;
                    if (((WillTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillTake)observer).willTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidTake(int upper, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidTake) {
                if (((DidTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidTake)observers).didTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidTake)) continue;
                    if (((DidTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidTake)observer).didTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillClear(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillClear) {
                if (((WillClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillClear)observers).willClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillClear)) continue;
                    if (((WillClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillClear)observer).willClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidClear(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidClear) {
                if (((DidClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidClear)observers).didClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidClear)) continue;
                    if (((DidClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidClear)observer).didClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public Value downlinkWillInsertValue(int index, Value newValue) {
        return newValue;
    }

    public void downlinkDidInsertValue(int index, Value newValue) {
    }

    public V downlinkWillInsert(int index, V newValue) {
        return newValue;
    }

    public void downlinkDidInsert(int index, V newValue) {
    }

    public Value downlinkWillUpdateValue(int index, Value newValue) {
        return newValue;
    }

    public void downlinkDidUpdateValue(int index, Value newValue, Value oldValue) {
    }

    public V downlinkWillUpdate(int index, V newValue) {
        return newValue;
    }

    public void downlinkDidUpdate(int index, V newValue, V oldValue) {
    }

    public void downlinkWillMoveValue(int fromIndex, int toIndex, Value value) {
    }

    public void downlinkDidMoveValue(int fromIndex, int toIndex, Value value) {
    }

    public void downlinkWillMove(int fromIndex, int toIndex, V value) {
    }

    public void downlinkDidMove(int fromIndex, int toIndex, V value) {
    }

    public void downlinkWillRemoveValue(int index) {
    }

    public void downlinkDidRemoveValue(int index, Value oldValue) {
    }

    public void downlinkWillRemove(int index) {
    }

    public void downlinkDidRemove(int index, V oldValue) {
    }

    public void downlinkWillDrop(int lower) {
    }

    public void downlinkDidDrop(int lower) {
    }

    public void downlinkWillTake(int upper) {
    }

    public void downlinkDidTake(int upper) {
    }

    public void downlinkWillClear() {
    }

    public void downlinkDidClear() {
    }

    @Override
    public ListDownlinkModel createDownlinkModel() {
        return new ListDownlinkModel(this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public ListDownlinkView<V> open() {
        if (this.model == null) {
            LinkBinding linkBinding = this.cellContext.bindDownlink(this);
            if (linkBinding instanceof ListDownlinkModel) {
                this.model = (ListDownlinkModel)linkBinding;
                this.model.addDownlink(this);
            } else {
                throw new DownlinkException("downlink type mismatch");
            }
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        this.model = null;
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public boolean contains(Object o) {
        return this.model.contains(o);
    }

    public int size() {
        return this.model.size();
    }

    public V get(int index) {
        return this.get(index, null);
    }

    public V set(int index, V element) {
        return this.model.set(this, index, element);
    }

    public void add(int index, V element) {
        this.model.add(this, index, element);
    }

    public V remove(int index) {
        return this.model.remove(this, index);
    }

    public int indexOf(Object o) {
        return this.model.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.model.lastIndexOf(o);
    }

    public ListIterator<V> listIterator() {
        if (this.valueForm != Form.forValue()) {
            return new ValueListIterator(this.model.listIterator(), this.valueForm);
        }
        return this.model.listIterator();
    }

    public ListIterator<V> listIterator(int index) {
        if (this.valueForm != Form.forValue()) {
            return new ValueListIterator(this.model.listIterator(index), this.valueForm);
        }
        return this.model.listIterator(index);
    }

    public List<V> subList(int fromIndex, int toIndex) {
        return new ValueList(this.model.subList(fromIndex, toIndex), this.valueForm);
    }

    public void drop(int lower) {
        this.model.drop(this, lower);
    }

    public void take(int upper) {
        this.model.take(this, upper);
    }

    public void clear() {
        this.model.clear(this);
    }

    public Iterator<V> iterator() {
        if (this.valueForm != Form.forValue()) {
            return new ValueIterator(this.model.iterator(), this.valueForm);
        }
        return this.model.iterator();
    }

    public Object[] toArray() {
        return this.model.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.model.toArray(a);
    }

    public boolean add(V v) {
        return this.model.add(this, this.size(), v);
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index != -1) {
            Object oldObject = this.model.remove(this, index);
            return oldObject != null && oldObject != this.valueForm.unit();
        }
        return false;
    }

    public boolean containsAll(Collection<?> elements) {
        for (Object element : elements) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends V> elements) {
        boolean added = false;
        for (V element : elements) {
            added = added || this.add(element);
        }
        return added;
    }

    public boolean addAll(int index, Collection<? extends V> elements) {
        for (V element : elements) {
            this.add(index, element);
        }
        return elements.isEmpty();
    }

    public boolean removeAll(Collection<?> elements) {
        boolean removed = false;
        for (Object element : elements) {
            removed = removed || this.remove(element);
        }
        return removed;
    }

    public boolean retainAll(Collection<?> elements) {
        boolean modified = false;
        for (Object element : elements) {
            if (elements.contains(element)) continue;
            modified = modified || this.remove(element);
        }
        return modified;
    }

    public V get(int index, Object key) {
        Value value = this.model.get(index, key);
        Object object = this.valueForm.cast((Item)value);
        if (object != null) {
            return (V)object;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<Object, V> getEntry(int index) {
        if (this.valueForm != Form.forValue()) {
            return new ListDownlinkViewEntry<V>(this.model.getEntry(index), this.valueForm);
        }
        return this.model.getEntry(index);
    }

    public Map.Entry<Object, V> getEntry(int index, Object key) {
        if (this.valueForm != Form.forValue()) {
            return new ListDownlinkViewEntry<V>(this.model.getEntry(index, key), this.valueForm);
        }
        return this.model.getEntry(index, key);
    }

    public V set(int index, V element, Object key) {
        return this.model.set(this, index, element, key);
    }

    public boolean add(V element, Object key) {
        return this.model.add(this, this.size(), element, key);
    }

    public void add(int index, V element, Object key) {
        this.model.add(this, index, element, key);
    }

    public V remove(int index, Object key) {
        return this.model.remove(this, index, key);
    }

    public void move(int fromIndex, int toIndex) {
        this.model.move(this, fromIndex, toIndex, null);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        this.model.move(this, fromIndex, toIndex, key);
    }

    public ListIterator<Object> keyIterator() {
        return this.model.keyIterator();
    }

    public ListIterator<Map.Entry<Object, V>> entryIterator() {
        return new ListDownlinkViewEntryIterator<V>(this.model.entryIterator(), this.valueForm);
    }
}

