/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.DownlinkRelay;
import swim.runtime.downlink.MapDownlinkModel;
import swim.runtime.downlink.MapDownlinkView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class MapDownlinkRelayClear
extends DownlinkRelay<MapDownlinkModel, MapDownlinkView<?, ?>> {
    final EventMessage message;
    final Cont<EventMessage> cont;

    MapDownlinkRelayClear(MapDownlinkModel model, EventMessage message, Cont<EventMessage> cont) {
        super(model, 4);
        this.message = message;
        this.cont = cont;
    }

    MapDownlinkRelayClear(MapDownlinkModel model, Stage stage) {
        super(model, 1, 3, stage);
        this.message = null;
        this.cont = null;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2 && ((MapDownlinkModel)this.model).isStateful()) {
            ((MapDownlinkModel)this.model).state.clear();
        }
    }

    @Override
    protected boolean runPhase(MapDownlinkView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.downlinkWillClear();
            }
            return view.dispatchWillClear(preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidClear();
            }
            return view.dispatchDidClear(preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        if (this.message != null) {
            ((MapDownlinkModel)this.model).cueDown();
        } else {
            ((MapDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("clear"));
        }
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

