/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import swim.api.DownlinkException;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.downlink.ValueDownlink;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.api.warp.function.DidLink;
import swim.api.warp.function.DidReceive;
import swim.api.warp.function.DidSync;
import swim.api.warp.function.DidUnlink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillLink;
import swim.api.warp.function.WillReceive;
import swim.api.warp.function.WillSync;
import swim.api.warp.function.WillUnlink;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.observable.function.DidSet;
import swim.observable.function.WillSet;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.downlink.ValueDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.streamlet.Inlet;
import swim.streamlet.Outlet;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Cursor;

public class ValueDownlinkView<V>
extends WarpDownlinkView
implements ValueDownlink<V> {
    protected static final int STATEFUL = 4;
    protected final Form<V> valueForm;
    protected ValueDownlinkModel model;
    protected Outlet<? extends V> input;
    protected Inlet<? super V>[] outputs;
    protected int version;

    public ValueDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Form<V> valueForm, Object observers) {
        super(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, flags, observers);
        this.valueForm = valueForm;
        this.input = null;
        this.outputs = null;
        this.version = -1;
    }

    public ValueDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, Form<V> valueForm) {
        this(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, 7, valueForm, null);
    }

    @Override
    public ValueDownlinkModel downlinkModel() {
        return this.model;
    }

    @Override
    public ValueDownlinkView<V> hostUri(Uri hostUri) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public ValueDownlinkView<V> nodeUri(Uri nodeUri) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    @Override
    public ValueDownlinkView<V> laneUri(Uri laneUri) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri, this.prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    @Override
    public ValueDownlinkView<V> prio(float prio) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, prio, this.rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> rate(float rate) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, rate, this.body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> body(Value body) {
        return new ValueDownlinkView<V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, body, this.flags, this.valueForm, this.observers);
    }

    @Override
    public ValueDownlinkView<V> keepLinked(boolean keepLinked) {
        this.flags = keepLinked ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    @Override
    public ValueDownlinkView<V> keepSynced(boolean keepSynced) {
        this.flags = keepSynced ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        return this;
    }

    public final boolean isStateful() {
        return (this.flags & 4) != 0;
    }

    public ValueDownlinkView<V> isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        ValueDownlinkModel model = this.model;
        if (this.model != null) {
            this.model.isStateful(isStateful);
        }
        return this;
    }

    void didSetStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ValueDownlinkView<V2> valueForm(Form<V2> valueForm) {
        return new ValueDownlinkView<V2>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> ValueDownlinkView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    @Override
    public ValueDownlinkView<V> observe(Object observer) {
        return (ValueDownlinkView)super.observe(observer);
    }

    @Override
    public ValueDownlinkView<V> unobserve(Object observer) {
        return (ValueDownlinkView)super.unobserve(observer);
    }

    public ValueDownlinkView<V> willSet(WillSet<V> willSet) {
        return this.observe(willSet);
    }

    public ValueDownlinkView<V> didSet(DidSet<V> didSet) {
        return this.observe(didSet);
    }

    @Override
    public ValueDownlinkView<V> willReceive(WillReceive willReceive) {
        return this.observe(willReceive);
    }

    @Override
    public ValueDownlinkView<V> didReceive(DidReceive didReceive) {
        return this.observe(didReceive);
    }

    @Override
    public ValueDownlinkView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public ValueDownlinkView<V> willLink(WillLink willLink) {
        return this.observe(willLink);
    }

    @Override
    public ValueDownlinkView<V> didLink(DidLink didLink) {
        return this.observe(didLink);
    }

    @Override
    public ValueDownlinkView<V> willSync(WillSync willSync) {
        return this.observe(willSync);
    }

    @Override
    public ValueDownlinkView<V> didSync(DidSync didSync) {
        return this.observe(didSync);
    }

    @Override
    public ValueDownlinkView<V> willUnlink(WillUnlink willUnlink) {
        return this.observe(willUnlink);
    }

    @Override
    public ValueDownlinkView<V> didUnlink(DidUnlink didUnlink) {
        return this.observe(didUnlink);
    }

    @Override
    public ValueDownlinkView<V> didConnect(DidConnect didConnect) {
        return this.observe(didConnect);
    }

    @Override
    public ValueDownlinkView<V> didDisconnect(DidDisconnect didDisconnect) {
        return this.observe(didDisconnect);
    }

    @Override
    public ValueDownlinkView<V> didClose(DidClose didClose) {
        return this.observe(didClose);
    }

    @Override
    public ValueDownlinkView<V> didFail(DidFail didFail) {
        return this.observe(didFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillSet(V newValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillSet) {
                if (((WillSet)observers).isPreemptive() == preemptive) {
                    try {
                        newValue = ((WillSet)observers).willSet(newValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillSet)) continue;
                    if (((WillSet)observer).isPreemptive() == preemptive) {
                        try {
                            newValue = ((WillSet)observer).willSet(newValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidSet(V newValue, V oldValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidSet) {
                if (((DidSet)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidSet)observers).didSet(newValue, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidSet)) continue;
                    if (((DidSet)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidSet)observer).didSet(newValue, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public Value downlinkWillSetValue(Value newValue) {
        return newValue;
    }

    public void downlinkDidSetValue(Value newValue, Value oldValue) {
    }

    public V downlinkWillSet(V newValue) {
        return newValue;
    }

    public void downlinkDidSet(V newValue, V oldValue) {
        this.decohere();
        this.recohere(0);
    }

    @Override
    public ValueDownlinkModel createDownlinkModel() {
        return new ValueDownlinkModel(this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public ValueDownlinkView<V> open() {
        if (this.model == null) {
            LinkBinding linkBinding = this.cellContext.bindDownlink(this);
            if (linkBinding instanceof ValueDownlinkModel) {
                this.model = (ValueDownlinkModel)linkBinding;
                this.model.addDownlink(this);
            } else {
                throw new DownlinkException("downlink type mismatch");
            }
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        this.model = null;
    }

    public V get() {
        Object state = this.valueForm.cast((Item)this.model.get());
        if (state == null) {
            return (V)this.valueForm.unit();
        }
        return (V)state;
    }

    public V set(V newValue) {
        return this.model.set(this, newValue);
    }

    public Outlet<? extends V> input() {
        return this.input;
    }

    public void bindInput(Outlet<? extends V> input) {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput((Inlet)this);
        }
    }

    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = null;
    }

    public void disconnectInputs() {
        Outlet<? extends V> input = this.input;
        if (input != null) {
            input.unbindOutput((Inlet)this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    public Iterator<Inlet<? super V>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    public void bindOutput(Inlet<? super V> output) {
        Inlet<? super V>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    public void unbindOutput(Inlet<? super V> output) {
        Inlet<? super V>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    public void unbindOutputs() {
        Inlet<? super V>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<? super V> output : outputs) {
                output.unbindInput();
            }
        }
    }

    public void disconnectOutputs() {
        Inlet<? super V>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<? super V> output : outputs) {
                output.unbindInput();
                output.disconnectOutputs();
            }
        }
    }

    public void decohereOutput() {
        this.decohere();
    }

    public void decohereInput() {
        this.decohere();
    }

    public void decohere() {
        if (this.version >= 0) {
            this.willDecohere();
            this.version = -1;
            this.onDecohere();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].decohereOutput();
            }
            this.didDecohere();
        }
    }

    public void recohereOutput(int version) {
        this.recohere(version);
    }

    public void recohereInput(int version) {
        this.recohere(version);
    }

    public void recohere(int version) {
        if (this.version < 0) {
            this.willRecohere(version);
            this.version = version;
            if (this.input != null) {
                this.input.recohereInput(version);
            }
            this.onRecohere(version);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].recohereOutput(version);
            }
            this.didRecohere(version);
        }
    }

    protected void willDecohere() {
    }

    protected void onDecohere() {
    }

    protected void didDecohere() {
    }

    protected void willRecohere(int version) {
    }

    protected void onRecohere(int version) {
        if (this.input != null) {
            Object value = this.input.get();
            this.set(value);
        }
    }

    protected void didRecohere(int version) {
    }
}

