/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.ListIterator;
import java.util.Map;
import swim.api.LaneException;
import swim.api.data.ListData;
import swim.collections.FingerTrieSeq;
import swim.runtime.LaneView;
import swim.runtime.Push;
import swim.runtime.WarpBinding;
import swim.runtime.lane.ListLaneRelayClear;
import swim.runtime.lane.ListLaneRelayDrop;
import swim.runtime.lane.ListLaneRelayMove;
import swim.runtime.lane.ListLaneRelayRemove;
import swim.runtime.lane.ListLaneRelayTake;
import swim.runtime.lane.ListLaneRelayUpdate;
import swim.runtime.lane.ListLaneUplink;
import swim.runtime.lane.ListLaneView;
import swim.runtime.warp.ListLinkDelta;
import swim.runtime.warp.WarpLaneModel;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class ListLaneModel
extends WarpLaneModel<ListLaneView<?>, ListLaneUplink> {
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;
    protected int flags;
    protected ListData<Value> data;

    ListLaneModel(int flags) {
        this.flags = flags;
    }

    public ListLaneModel() {
        this(0);
    }

    @Override
    public String laneType() {
        return "list";
    }

    @Override
    protected ListLaneUplink createWarpUplink(WarpBinding link) {
        return new ListLaneUplink(this, link, this.createUplinkAddress(link));
    }

    @Override
    protected void didOpenLaneView(ListLaneView<?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(Push<CommandMessage> push) {
        CommandMessage message = push.message();
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                Value value = payload.body();
                new ListLaneRelayUpdate(this, message, push.cont(), index, value, key).run();
            }
        } else if ("move".equals(tag)) {
            Value header = payload.header("move");
            int fromIndex = header.get("from").intValue(-1);
            int toIindex = header.get("to").intValue(-1);
            if (fromIndex > -1 && toIindex > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                new ListLaneRelayMove(this, message, push.cont(), fromIndex, toIindex, key).run();
            }
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDistinct() ? header.get("key") : null;
                new ListLaneRelayRemove(this, message, push.cont(), index, key).run();
            }
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new ListLaneRelayDrop(this, message, push.cont(), lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new ListLaneRelayTake(this, message, push.cont(), upper).run();
        } else if ("clear".equals(tag)) {
            new ListLaneRelayClear(this, message, push.cont()).run();
        } else {
            push.trap((Throwable)new LaneException("unknown subcommand: " + payload));
        }
    }

    protected void sendDown(ListLinkDelta delta) {
        FingerTrieSeq uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ListLaneUplink uplink = (ListLaneUplink)uplinks.get(i);
                if (uplink.isConnected()) {
                    uplink.sendDown(delta);
                    continue;
                }
                closedLinks = closedLinks.appended((Object)uplink.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ListLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ListLaneView) {
            ((ListLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ListLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ListLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ListLaneView) {
            ((ListLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ListLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public <V> boolean add(ListLaneView<V> view, int index, V newObject) {
        return this.add(view, index, newObject, null);
    }

    public <V> boolean add(ListLaneView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListLaneRelayUpdate relay = new ListLaneRelayUpdate(this, this.stage(), index, newValue, key);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        return relay.newObject != null;
    }

    public <V> V set(ListLaneView<V> view, int index, V newObject) {
        return this.set(view, index, newObject, null);
    }

    public <V> V set(ListLaneView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListLaneRelayUpdate relay = new ListLaneRelayUpdate(this, this.stage(), index, newValue, key);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public void move(int fromIndex, int toIndex) {
        this.move(fromIndex, toIndex, null);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        ListLaneRelayMove relay = new ListLaneRelayMove(this, this.stage(), fromIndex, toIndex, key);
        relay.run();
    }

    public <V> V remove(ListLaneView<V> view, int index) {
        return this.remove(view, index, null);
    }

    public <V> V remove(ListLaneView<V> view, int index, Object key) {
        Form valueForm = view.valueForm;
        Map.Entry entry = this.data.getEntry(index, key);
        if (entry != null) {
            Object actualKey = key == null ? entry.getKey() : key;
            ListLaneRelayRemove relay = new ListLaneRelayRemove(this, this.stage(), index, actualKey);
            relay.valueForm = valueForm;
            relay.run();
            if (relay.valueForm != valueForm && valueForm != null) {
                relay.oldObject = valueForm.cast((Item)relay.oldValue);
                if (relay.oldObject == null) {
                    relay.oldObject = valueForm.unit();
                }
            }
            return (V)relay.oldObject;
        }
        return null;
    }

    public void drop(ListLaneView<?> view, int lower) {
        if (lower > 0) {
            ListLaneRelayDrop relay = new ListLaneRelayDrop(this, this.stage(), lower);
            relay.run();
        }
    }

    public void take(ListLaneView<?> view, int upper) {
        if (upper > 0) {
            ListLaneRelayTake relay = new ListLaneRelayTake(this, this.stage(), upper);
            relay.run();
        }
    }

    public void clear(ListLaneView<?> view) {
        ListLaneRelayClear relay = new ListLaneRelayClear(this, this.stage());
        relay.run();
    }

    public ListIterator<Map.Entry<Object, Value>> iterator() {
        return this.data.entryIterator();
    }

    protected void openStore() {
        this.data = this.laneContext.store().listData(this.laneUri().toString()).isTransient(this.isTransient()).isResident(this.isResident());
    }

    @Override
    protected void willLoad() {
        this.openStore();
        super.willLoad();
    }
}

