/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.runtime.warp.ListLinkDelta;
import swim.warp.CommandMessage;

final class ListLaneRelayClear
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;

    ListLaneRelayClear(ListLaneModel model, CommandMessage message, Cont<CommandMessage> cont) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
    }

    ListLaneRelayClear(ListLaneModel model, Link link) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
    }

    ListLaneRelayClear(ListLaneModel model, Stage stage) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            ((ListLaneModel)this.model).data.clear();
        }
    }

    @Override
    protected boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            view.laneWillClear();
            return view.dispatchWillClear(this.link, preemptive);
        }
        if (phase == 2) {
            view.laneDidClear();
            return view.dispatchDidClear(this.link, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((ListLaneModel)this.model).sendDown(ListLinkDelta.clear());
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

