/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.runtime.warp.ListLinkDelta;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ListLaneRelayMove
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;
    final int fromIndex;
    final int toIndex;
    final Object key;
    Form<Object> valueForm;
    Value value;
    Object object;

    ListLaneRelayMove(ListLaneModel model, CommandMessage message, Cont<CommandMessage> cont, int fromIndex, int toIndex, Object key) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    ListLaneRelayMove(ListLaneModel model, Link link, int fromIndex, int toIndex, Object key) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    ListLaneRelayMove(ListLaneModel model, Stage stage, int fromIndex, int toIndex, Object key) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            ((ListLaneModel)this.model).data.move(this.fromIndex, this.toIndex, this.key);
        }
    }

    @Override
    protected boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.value = (Value)((ListLaneModel)this.model).data.get(this.fromIndex, this.key);
                this.object = valueForm.cast((Item)this.value);
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneWillMove(this.fromIndex, this.toIndex, this.object);
            }
            return view.dispatchWillMove(this.link, this.fromIndex, this.toIndex, this.object, preemptive);
        }
        if (phase == 2) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.object = valueForm.cast((Item)this.value);
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidMove(this.fromIndex, this.toIndex, this.object);
            }
            return view.dispatchDidMove(this.link, this.fromIndex, this.toIndex, this.object, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((ListLaneModel)this.model).sendDown(ListLinkDelta.move(this.fromIndex, this.toIndex, Value.fromObject((Object)this.key)));
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

