/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.LaneRelay;
import swim.runtime.lane.SpatialLaneModel;
import swim.runtime.lane.SpatialLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class SpatialLaneRelayRemove<S>
extends LaneRelay<SpatialLaneModel<S>, SpatialLaneView<?, S, ?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;
    final Value key;
    final S shapeObject;
    Form<Object> keyForm;
    Z2Form<Object> shapeForm;
    Form<Object> valueForm;
    Object keyObject;
    Value oldValue;
    Object oldObject;

    SpatialLaneRelayRemove(SpatialLaneModel<S> model, CommandMessage message, Cont<CommandMessage> cont, Value key, S shapeObject) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
        this.key = key;
        this.shapeObject = shapeObject;
    }

    SpatialLaneRelayRemove(SpatialLaneModel<S> model, Link link, Value key, S shapeObject) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.shapeObject = shapeObject;
    }

    SpatialLaneRelayRemove(SpatialLaneModel<S> model, Stage stage, Value key, S shapeObject) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.shapeObject = shapeObject;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((SpatialLaneModel)this.model).data.remove((Object)this.key, this.shapeObject);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    protected boolean runPhase(SpatialLaneView<?, S, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneWillRemove(this.keyObject, this.shapeObject);
            }
            return view.dispatchWillRemove(this.link, this.keyObject, this.shapeObject, preemptive);
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidRemove(this.keyObject, this.shapeObject);
            }
            return view.dispatchDidRemove(this.link, this.keyObject, this.shapeObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        Record header = Record.create((int)2).slot("key", this.key).slot("shape", this.shapeForm.mold(this.shapeObject).toValue());
        ((SpatialLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("move", (Value)header));
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

