/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.reflect.LogEntry;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class LogEntryForm
extends Form<LogEntry> {
    LogEntryForm() {
    }

    public Class<?> type() {
        return LogEntry.class;
    }

    public Item mold(LogEntry entry) {
        if (entry != null) {
            Record header = Record.create((int)3);
            header.slot("time", entry.time);
            if (entry.nodeUri.isDefined()) {
                header.slot("node", entry.nodeUri.toString());
            }
            if (entry.laneUri.isDefined()) {
                header.slot("lane", entry.laneUri.toString());
            }
            return Attr.of((String)entry.tag, (Value)header).concat((Item)entry.message);
        }
        return Item.extant();
    }

    public LogEntry cast(Item item) {
        Value value = item.toValue();
        Item head = value.head();
        if (head instanceof Attr) {
            String tag = ((Attr)head).name();
            Value header = ((Attr)head).value();
            long time = header.get("time").longValue(0L);
            Uri nodeUri = (Uri)header.get("node").coerce(Uri.form());
            Uri laneUri = (Uri)header.get("lane").coerce(Uri.form());
            Value message = value.body();
            return new LogEntry(tag, time, nodeUri, laneUri, message);
        }
        return null;
    }
}

