/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.collections.FingerTrieSeq;
import swim.runtime.NodeBinding;
import swim.runtime.reflect.NodeInfoForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;

public class NodeInfo {
    private static Form<NodeInfo> form;
    protected final Uri nodeUri;
    protected final long created;
    protected final FingerTrieSeq<Value> agentIds;
    protected final long childCount;

    public NodeInfo(Uri nodeUri, long created, FingerTrieSeq<Value> agentIds, long childCount) {
        this.nodeUri = nodeUri;
        this.created = created;
        this.agentIds = agentIds;
        this.childCount = childCount;
    }

    public static NodeInfo from(NodeBinding nodeBinding, long childCount) {
        return new NodeInfo(nodeBinding.nodeUri(), nodeBinding.createdTime(), nodeBinding.agentIds(), childCount);
    }

    public static NodeInfo from(NodeBinding nodeBinding) {
        return NodeInfo.from(nodeBinding, 0L);
    }

    @Kind
    public static Form<NodeInfo> form() {
        if (form == null) {
            form = new NodeInfoForm();
        }
        return form;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public final long created() {
        return this.created;
    }

    public final FingerTrieSeq<Value> agentIds() {
        return this.agentIds;
    }

    public final long childCount() {
        return this.childCount;
    }

    public Value toValue() {
        return NodeInfo.form().mold((Object)this).toValue();
    }
}

