/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.collections.FingerTrieSeq;
import swim.runtime.reflect.NodeInfo;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class NodeInfoForm
extends Form<NodeInfo> {
    NodeInfoForm() {
    }

    public Class<?> type() {
        return NodeInfo.class;
    }

    public Item mold(NodeInfo info) {
        if (info != null) {
            int agentCount;
            Record record = Record.create((int)4);
            record.slot("nodeUri", info.nodeUri.toString());
            record.slot("created", info.created);
            if (info.childCount != 0L) {
                record.slot("childCount", info.childCount);
            }
            if ((agentCount = info.agentIds.size()) != 0) {
                Record agents = Record.create((int)agentCount);
                for (int i = 0; i < agentCount; ++i) {
                    agents.add((Item)info.agentIds.get(i));
                }
                record.slot("agents", (Value)agents);
            }
            return record;
        }
        return Item.extant();
    }

    public NodeInfo cast(Item item) {
        Value value = item.toValue();
        Uri nodeUri = (Uri)Uri.form().cast((Item)value.get("nodeUri"));
        if (nodeUri != null) {
            long created = value.get("created").longValue(0L);
            FingerTrieSeq agentIds = FingerTrieSeq.empty();
            Value agents = value.get("agents");
            int n = agents.length();
            for (int i = 0; i < n; ++i) {
                agentIds = agentIds.appended((Object)agents.getItem(i).toValue());
            }
            long childCount = value.get("childCount").longValue(0L);
            return new NodeInfo(nodeUri, created, (FingerTrieSeq<Value>)agentIds, childCount);
        }
        return null;
    }
}

