/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.reflect;

import swim.runtime.PartPredicate;
import swim.runtime.reflect.PartInfo;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class PartInfoForm
extends Form<PartInfo> {
    PartInfoForm() {
    }

    public Class<?> type() {
        return PartInfo.class;
    }

    public Item mold(PartInfo info) {
        if (info != null) {
            Record record = Record.create((int)4);
            record.slot("partKey", info.partKey);
            record.slot("predicate", info.predicate.toValue());
            if (info.masterHostUri.isDefined()) {
                record.slot("masterHostUri", info.masterHostUri.toString());
            }
            if (info.hostCount != 0) {
                record.slot("hostCount", info.hostCount);
            }
            return record;
        }
        return Item.extant();
    }

    public PartInfo cast(Item item) {
        Value value = item.toValue();
        Value partKey = value.get("partKey");
        if (partKey.isDefined()) {
            PartPredicate predicate = (PartPredicate)PartPredicate.form().cast((Item)value.get("predicate"));
            Uri masterHostUri = (Uri)Uri.form().cast((Item)value.get("masterHostUri"));
            int hostCount = value.get("hostCount").intValue(0);
            return new PartInfo(partKey, predicate, masterHostUri, hostCount);
        }
        return null;
    }
}

