/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import swim.api.lane.function.OnCueKey;
import swim.api.lane.function.OnSyncKeys;
import swim.api.warp.WarpUplink;
import swim.collections.FingerTrieSeq;
import swim.runtime.HostBinding;
import swim.runtime.NodeBinding;
import swim.runtime.reflect.NodeInfo;
import swim.runtime.router.HostTableNodesChildIterator;
import swim.runtime.router.HostTableNodesQueryIterator;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriFragment;
import swim.uri.UriMapper;

final class HostTableNodesController
implements OnCueKey<Uri, NodeInfo>,
OnSyncKeys<Uri> {
    final HostBinding host;

    HostTableNodesController(HostBinding host) {
        this.host = host;
    }

    public NodeInfo onCue(Uri nodeUri, WarpUplink uplink) {
        String laneQuery = uplink.laneUri().query().get((Object)"q");
        UriFragment laneFragment = uplink.laneUri().fragment();
        if (laneQuery != null) {
            NodeBinding nodeBinding;
            if (nodeUri.toString().contains(laneQuery) && (nodeBinding = this.host.getNode(nodeUri)) != null) {
                return NodeInfo.from(nodeBinding);
            }
        } else if (laneFragment.isDefined()) {
            Uri parentUri = Uri.parse((String)laneFragment.identifier());
            if (nodeUri.isChildOf(parentUri)) {
                NodeBinding nodeBinding = this.host.getNode(nodeUri);
                Uri directoryUri = nodeUri.appendedSlash();
                UriMapper directory = this.host.nodes().getSuffix(directoryUri);
                if (nodeBinding != null) {
                    return NodeInfo.from(nodeBinding, directory.childCount());
                }
                if (!directory.isEmpty()) {
                    return new NodeInfo(nodeUri, 0L, (FingerTrieSeq<Value>)FingerTrieSeq.empty(), directory.childCount());
                }
            }
        } else {
            NodeBinding nodeBinding = this.host.getNode(nodeUri);
            if (nodeBinding != null) {
                return NodeInfo.from(nodeBinding);
            }
        }
        return null;
    }

    public Iterator<Uri> onSync(WarpUplink uplink) {
        String laneQuery = uplink.laneUri().query().get((Object)"q");
        UriFragment laneFragment = uplink.laneUri().fragment();
        if (laneQuery != null) {
            return new HostTableNodesQueryIterator(laneQuery, this.host.nodes().iterator());
        }
        if (laneFragment.isDefined()) {
            Uri parentUri = Uri.parse((String)laneFragment.identifier());
            UriMapper parentSuffix = this.host.nodes().getSuffix(parentUri);
            return new HostTableNodesChildIterator(parentUri, parentSuffix.childIterator());
        }
        return this.host.nodes().keyIterator();
    }
}

