/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.ConcurrentLinkedQueue;
import swim.concurrent.Cont;
import swim.runtime.Push;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public abstract class SupplyDownlinkModem<View extends WarpDownlinkView>
extends WarpDownlinkModel<View> {
    final ConcurrentLinkedQueue<Push<CommandMessage>> upQueue = new ConcurrentLinkedQueue();

    public SupplyDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    protected boolean upQueueIsEmpty() {
        return this.upQueue.isEmpty();
    }

    @Override
    protected void queueUp(Value body, Cont<CommandMessage> cont) {
        Uri hostUri = this.hostUri();
        Uri nodeUri = this.nodeUri();
        Uri laneUri = this.laneUri();
        float prio = this.prio();
        CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
        this.upQueue.add(new Push<CommandMessage>(Uri.empty(), hostUri, nodeUri, laneUri, prio, null, message, cont));
    }

    @Override
    protected Push<CommandMessage> nextUpQueue() {
        return this.upQueue.poll();
    }
}

