/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.runtime.DownlinkRelay;
import swim.runtime.Push;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.warp.EventMessage;

final class WarpDownlinkRelayOnEvent<View extends WarpDownlinkView>
extends DownlinkRelay<WarpDownlinkModel<View>, View> {
    final Push<EventMessage> push;

    WarpDownlinkRelayOnEvent(WarpDownlinkModel<View> model, Push<EventMessage> push) {
        super(model, 2);
        this.push = push;
    }

    @Override
    protected boolean runPhase(View view, int phase, boolean preemptive) {
        if (phase == 0) {
            EventMessage message = this.push.message();
            if (preemptive) {
                ((WarpDownlinkView)view).downlinkWillReceive(message);
            }
            return ((WarpDownlinkView)view).dispatchWillReceive(message.body(), preemptive);
        }
        if (phase == 1) {
            EventMessage message = this.push.message();
            if (preemptive) {
                ((WarpDownlinkView)view).downlinkDidReceive(message);
            }
            return ((WarpDownlinkView)view).dispatchDidReceive(message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        this.push.bind();
        ((WarpDownlinkModel)this.model).cueDown();
    }
}

