/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.api.Link;
import swim.api.SwimContext;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.api.warp.WarpDownlink;
import swim.api.warp.function.DidLink;
import swim.api.warp.function.DidReceive;
import swim.api.warp.function.DidSync;
import swim.api.warp.function.DidUnlink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillLink;
import swim.api.warp.function.WillReceive;
import swim.api.warp.function.WillSync;
import swim.api.warp.function.WillUnlink;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.DownlinkView;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkModem;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class WarpDownlinkView
extends DownlinkView
implements WarpDownlink {
    protected static final int KEEP_LINKED = 1;
    protected static final int KEEP_SYNCED = 2;
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;
    protected final Uri laneUri;
    protected final float prio;
    protected final float rate;
    protected final Value body;
    protected volatile int flags;

    public WarpDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Object observers) {
        super(cellContext, stage, observers);
        this.meshUri = meshUri.isDefined() ? meshUri : hostUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.prio = prio;
        this.rate = rate;
        this.body = body;
        this.flags = flags;
    }

    public abstract WarpDownlinkModel<?> downlinkModel();

    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public abstract WarpDownlinkView hostUri(Uri var1);

    public abstract WarpDownlinkView hostUri(String var1);

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public abstract WarpDownlinkView nodeUri(Uri var1);

    public abstract WarpDownlinkView nodeUri(String var1);

    public final Uri laneUri() {
        return this.laneUri;
    }

    public abstract WarpDownlinkView laneUri(Uri var1);

    public abstract WarpDownlinkView laneUri(String var1);

    public final float prio() {
        return this.prio;
    }

    public abstract WarpDownlinkView prio(float var1);

    public final float rate() {
        return this.rate;
    }

    public abstract WarpDownlinkView rate(float var1);

    public final Value body() {
        return this.body;
    }

    public abstract WarpDownlinkView body(Value var1);

    public final boolean keepLinked() {
        return (this.flags & 1) != 0;
    }

    public abstract WarpDownlinkView keepLinked(boolean var1);

    public final boolean keepSynced() {
        return (this.flags & 2) != 0;
    }

    public abstract WarpDownlinkView keepSynced(boolean var1);

    @Override
    public WarpDownlinkView observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public WarpDownlinkView unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public abstract WarpDownlinkView willReceive(WillReceive var1);

    public abstract WarpDownlinkView didReceive(DidReceive var1);

    public abstract WarpDownlinkView willCommand(WillCommand var1);

    public abstract WarpDownlinkView willLink(WillLink var1);

    public abstract WarpDownlinkView didLink(DidLink var1);

    public abstract WarpDownlinkView willSync(WillSync var1);

    public abstract WarpDownlinkView didSync(DidSync var1);

    public abstract WarpDownlinkView willUnlink(WillUnlink var1);

    public abstract WarpDownlinkView didUnlink(DidUnlink var1);

    @Override
    public abstract WarpDownlinkView didConnect(DidConnect var1);

    @Override
    public abstract WarpDownlinkView didDisconnect(DidDisconnect var1);

    @Override
    public abstract WarpDownlinkView didClose(DidClose var1);

    @Override
    public abstract WarpDownlinkView didFail(DidFail var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillReceive(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillReceive) {
                if (((WillReceive)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillReceive)observers).willReceive(body);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillReceive)) continue;
                    if (((WillReceive)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillReceive)observer).willReceive(body);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidReceive(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidReceive) {
                if (((DidReceive)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidReceive)observers).didReceive(body);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidReceive)) continue;
                    if (((DidReceive)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidReceive)observer).didReceive(body);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillCommand(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillCommand) {
                if (((WillCommand)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillCommand)observers).willCommand(body);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillCommand)) continue;
                    if (((WillCommand)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillCommand)observer).willCommand(body);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillLink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillLink) {
                if (((WillLink)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillLink)observers).willLink();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillLink)) continue;
                    if (((WillLink)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillLink)observer).willLink();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidLink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidLink) {
                if (((DidLink)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidLink)observers).didLink();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidLink)) continue;
                    if (((DidLink)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidLink)observer).didLink();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillSync(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillSync) {
                if (((WillSync)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillSync)observers).willSync();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillSync)) continue;
                    if (((WillSync)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillSync)observer).willSync();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidSync(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidSync) {
                if (((DidSync)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidSync)observers).didSync();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidSync)) continue;
                    if (((DidSync)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidSync)observer).didSync();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillUnlink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUnlink) {
                if (((WillUnlink)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillUnlink)observers).willUnlink();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUnlink)) continue;
                    if (((WillUnlink)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillUnlink)observer).willUnlink();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUnlink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUnlink) {
                if (((DidUnlink)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUnlink)observers).didUnlink();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUnlink)) continue;
                    if (((DidUnlink)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUnlink)observer).didUnlink();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public void downlinkWillReceive(EventMessage message) {
    }

    public void downlinkDidReceive(EventMessage message) {
    }

    public void downlinkWillCommand(CommandMessage message) {
    }

    public void downlinkWillLink(LinkRequest request) {
    }

    public void downlinkDidLink(LinkedResponse response) {
    }

    public void downlinkWillSync(SyncRequest request) {
    }

    public void downlinkDidSync(SyncedResponse response) {
    }

    public void downlinkWillUnlink(UnlinkRequest request) {
    }

    public void downlinkDidUnlink(UnlinkedResponse response) {
    }

    public abstract WarpDownlinkModel<?> createDownlinkModel();

    @Override
    public abstract WarpDownlinkView open();

    public void command(float prio, Value body, Cont<CommandMessage> cont) {
        ((WarpDownlinkModem)this.downlinkModel()).command(prio, body, cont);
    }

    public void command(Value body, Cont<CommandMessage> cont) {
        ((WarpDownlinkModem)this.downlinkModel()).command(body, cont);
    }

    public void command(float prio, Value body) {
        ((WarpDownlinkModem)this.downlinkModel()).command(prio, body);
    }

    public void command(Value body) {
        ((WarpDownlinkModem)this.downlinkModel()).command(body);
    }
}

