/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import swim.api.LaneException;
import swim.api.auth.Identity;
import swim.api.warp.WarpUplink;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.runtime.LaneModel;
import swim.runtime.LinkBinding;
import swim.runtime.Metric;
import swim.runtime.Push;
import swim.runtime.WarpBinding;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.runtime.profile.WarpLaneProfile;
import swim.runtime.profile.WarpUplinkProfile;
import swim.runtime.warp.WarpLaneRelayDidEnter;
import swim.runtime.warp.WarpLaneRelayDidLeave;
import swim.runtime.warp.WarpLaneRelayDidUplink;
import swim.runtime.warp.WarpLaneRelayOnCommand;
import swim.runtime.warp.WarpLaneView;
import swim.runtime.warp.WarpUplinkModem;
import swim.structure.Value;
import swim.warp.CommandMessage;

public abstract class WarpLaneModel<View extends WarpLaneView, U extends WarpUplinkModem>
extends LaneModel<View, U> {
    protected static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "execDelta");
    protected static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> EXEC_TIME = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "execTime");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "commandDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkOpenDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_OPEN_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkOpenCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkCloseDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_CLOSE_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkCloseCount");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkExecDelta");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_EXEC_RATE = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkExecRate");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkEventDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkEventRate");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkEventCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkCommandDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkCommandRate");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "downlinkCommandCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkOpenDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_OPEN_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkOpenCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkCloseDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_CLOSE_COUNT = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkCloseCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkEventDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkEventRate");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkEventCount");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkCommandDelta");
    static final AtomicIntegerFieldUpdater<WarpLaneModel<?, ?>> UPLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkCommandRate");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "uplinkCommandCount");
    static final AtomicLongFieldUpdater<WarpLaneModel<?, ?>> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(WarpLaneModel.class, "lastReportTime");
    volatile long execDelta;
    volatile long execTime;
    volatile int commandDelta;
    volatile int downlinkOpenDelta;
    volatile int downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile int downlinkCloseCount;
    volatile long downlinkExecDelta;
    volatile long downlinkExecRate;
    volatile int downlinkEventDelta;
    volatile int downlinkEventRate;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile int downlinkCommandRate;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile int uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile int uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile int uplinkEventRate;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile int uplinkCommandRate;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;

    @Override
    protected U createUplink(LinkBinding link) {
        if (link instanceof WarpBinding) {
            return this.createWarpUplink((WarpBinding)link);
        }
        return null;
    }

    protected abstract U createWarpUplink(WarpBinding var1);

    public void cueDown() {
        FingerTrieSeq uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                WarpUplinkModem uplink = (WarpUplinkModem)uplinks.get(i);
                if (uplink.isConnected()) {
                    uplink.cueDown();
                    continue;
                }
                closedLinks = closedLinks.appended((Object)uplink.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    public void sendDown(Value body) {
        FingerTrieSeq uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                WarpUplinkModem uplink = (WarpUplinkModem)uplinks.get(i);
                if (uplink.isConnected()) {
                    uplink.sendDown(body);
                    continue;
                }
                closedLinks = closedLinks.appended((Object)uplink.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    @Override
    public void pushUp(Push<?> push) {
        Object message = push.message();
        if (message instanceof CommandMessage) {
            this.onCommand(push);
        } else {
            push.trap((Throwable)new LaneException("unsupported message: " + message));
        }
    }

    @Override
    public void pushUpCommand(Push<CommandMessage> push) {
        this.onCommand(push);
        COMMAND_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void onCommand(Push<CommandMessage> push) {
        new WarpLaneRelayOnCommand(this, push.message(), push.cont()).run();
    }

    @Override
    protected void didOpenUplink(U uplink) {
        new WarpLaneRelayDidUplink(this, (WarpUplink)uplink).run();
        UPLINK_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    @Override
    protected void didCloseUplink(U uplink) {
        UPLINK_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didEnter(Identity identity) {
        new WarpLaneRelayDidEnter(this, identity).run();
    }

    protected void didLeave(Identity identity) {
        new WarpLaneRelayDidLeave(this, identity).run();
    }

    @Override
    public void didClose() {
        super.didClose();
        this.flushMetrics();
    }

    @Override
    public void reportDown(Metric metric) {
        if (metric instanceof WarpUplinkProfile) {
            this.accumulateWarpUplinkProfile((WarpUplinkProfile)metric);
        } else if (metric instanceof WarpDownlinkProfile) {
            this.accumulateWarpDownlinkProfile((WarpDownlinkProfile)metric);
        } else {
            super.reportDown(metric);
        }
    }

    @Override
    public void accumulateExecTime(long execDelta) {
        EXEC_DELTA.addAndGet(this, execDelta);
        this.didUpdateMetrics();
    }

    protected void accumulateWarpUplinkProfile(WarpUplinkProfile profile) {
        UPLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        UPLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        UPLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        UPLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void accumulateWarpDownlinkProfile(WarpDownlinkProfile profile) {
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.openDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.closeDelta());
        DOWNLINK_EXEC_DELTA.addAndGet(this, profile.execDelta());
        DOWNLINK_EXEC_RATE.addAndGet(this, profile.execRate());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        block4: {
            long dt;
            long newReportTime;
            long oldReportTime;
            do {
                oldReportTime = this.lastReportTime;
                newReportTime = System.currentTimeMillis();
                dt = newReportTime - oldReportTime;
                if (dt < 1000L) break block4;
            } while (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime));
            try {
                this.reportMetrics(dt);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        WarpLaneProfile profile = this.collectProfile(dt);
        this.laneContext.reportDown(profile);
    }

    protected WarpLaneProfile collectProfile(long dt) {
        int commandDelta = COMMAND_DELTA.getAndSet(this, 0);
        int commandRate = (int)Math.ceil(1000.0 * (double)commandDelta / (double)dt);
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        int downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        int downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        long downlinkExecDelta = DOWNLINK_EXEC_DELTA.getAndSet(this, 0L);
        long downlinkExecRate = DOWNLINK_EXEC_RATE.getAndSet(this, 0L);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = DOWNLINK_EVENT_RATE.getAndSet(this, 0);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = DOWNLINK_COMMAND_RATE.getAndSet(this, 0);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        int uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        int uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = UPLINK_EVENT_RATE.getAndSet(this, 0);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0) + commandDelta;
        int uplinkCommandRate = UPLINK_COMMAND_RATE.getAndSet(this, 0) + commandRate;
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        long execDelta = EXEC_DELTA.getAndSet(this, 0L) + downlinkExecDelta;
        long execRate = (long)Math.ceil(1000.0 * (double)execDelta / (double)dt) + downlinkExecRate;
        long execTime = EXEC_TIME.addAndGet(this, execDelta);
        return new WarpLaneProfile(this.cellAddress(), execDelta, execRate, execTime, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }
}

