/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.runtime.LaneRelay;
import swim.runtime.warp.WarpLaneModel;
import swim.runtime.warp.WarpLaneView;
import swim.warp.CommandMessage;

final class WarpLaneRelayOnCommand<View extends WarpLaneView>
extends LaneRelay<WarpLaneModel<View, ?>, View> {
    final CommandMessage message;
    final Cont<CommandMessage> cont;

    WarpLaneRelayOnCommand(WarpLaneModel<View, ?> model, CommandMessage message, Cont<CommandMessage> cont) {
        super(model, 2);
        this.message = message;
        this.cont = cont;
    }

    @Override
    protected boolean runPhase(View view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                ((WarpLaneView)view).laneWillCommand(this.message);
            }
            return ((WarpLaneView)view).dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                ((WarpLaneView)view).laneDidCommand(this.message);
            }
            return ((WarpLaneView)view).dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

