/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.function.DidClose;
import swim.api.warp.WarpUplink;
import swim.api.warp.function.OnCommandMessage;
import swim.api.warp.function.OnEventMessage;
import swim.api.warp.function.OnLinkRequest;
import swim.api.warp.function.OnLinkedResponse;
import swim.api.warp.function.OnSyncRequest;
import swim.api.warp.function.OnSyncedResponse;
import swim.api.warp.function.OnUnlinkRequest;
import swim.api.warp.function.OnUnlinkedResponse;
import swim.concurrent.Conts;
import swim.runtime.AbstractUplinkContext;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.Push;
import swim.runtime.UplinkAddress;
import swim.runtime.WarpBinding;
import swim.runtime.WarpContext;
import swim.runtime.profile.WarpUplinkProfile;
import swim.runtime.warp.WarpUplinkModemOnCommand;
import swim.runtime.warp.WarpUplinkModemOnLink;
import swim.runtime.warp.WarpUplinkModemOnSync;
import swim.runtime.warp.WarpUplinkModemOnUnlink;
import swim.runtime.warp.WarpUplinkModemPullDown;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class WarpUplinkModem
extends AbstractUplinkContext
implements WarpContext,
WarpUplink {
    static final int LINKED = 1;
    static final int LINKING = 2;
    static final int SYNCING = 4;
    static final int UNLINKING = 8;
    static final int CUED_DOWN = 16;
    static final int FEEDING_DOWN = 32;
    static final int FEEDING_UP = 64;
    static final int PULLING_UP = 128;
    static final AtomicIntegerFieldUpdater<WarpUplinkModem> STATUS = AtomicIntegerFieldUpdater.newUpdater(WarpUplinkModem.class, "status");
    static final AtomicIntegerFieldUpdater<WarpUplinkModem> EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpUplinkModem.class, "eventDelta");
    static final AtomicLongFieldUpdater<WarpUplinkModem> EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(WarpUplinkModem.class, "eventCount");
    static final AtomicIntegerFieldUpdater<WarpUplinkModem> COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(WarpUplinkModem.class, "commandDelta");
    static final AtomicLongFieldUpdater<WarpUplinkModem> COMMAND_TOTAL = AtomicLongFieldUpdater.newUpdater(WarpUplinkModem.class, "commandCount");
    static final AtomicLongFieldUpdater<WarpUplinkModem> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(WarpUplinkModem.class, "lastReportTime");
    protected final WarpBinding linkBinding;
    protected final UplinkAddress uplinkAddress;
    protected volatile int status;
    volatile int eventDelta;
    volatile long eventCount;
    volatile int commandDelta;
    volatile long commandCount;
    volatile long lastReportTime;

    protected WarpUplinkModem(WarpBinding linkBinding, UplinkAddress uplinkAddress) {
        this.linkBinding = linkBinding;
        this.uplinkAddress = uplinkAddress;
    }

    @Override
    public final WarpBinding linkWrapper() {
        return this.linkBinding.linkWrapper();
    }

    @Override
    public final WarpBinding linkBinding() {
        return this.linkBinding;
    }

    @Override
    public final Uri hostUri() {
        return this.linkBinding.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.linkBinding.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.linkBinding.laneUri();
    }

    @Override
    public final Value linkKey() {
        return this.uplinkAddress.linkKey();
    }

    @Override
    public final UplinkAddress cellAddressUp() {
        return this.uplinkAddress;
    }

    public final float prio() {
        return this.linkBinding.prio();
    }

    public final float rate() {
        return this.linkBinding.rate();
    }

    public final Value body() {
        return this.linkBinding.body();
    }

    @Override
    public WarpUplinkModem observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public WarpUplinkModem unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public WarpUplinkModem onEvent(OnEventMessage onEvent) {
        this.observe(onEvent);
        return this;
    }

    public WarpUplinkModem onCommand(OnCommandMessage onCommand) {
        this.observe(onCommand);
        return this;
    }

    public WarpUplinkModem onLink(OnLinkRequest onLink) {
        this.observe(onLink);
        return this;
    }

    public WarpUplinkModem onLinked(OnLinkedResponse onLinked) {
        this.observe(onLinked);
        return this;
    }

    public WarpUplinkModem onSync(OnSyncRequest onSync) {
        this.observe(onSync);
        return this;
    }

    public WarpUplinkModem onSynced(OnSyncedResponse onSynced) {
        this.observe(onSynced);
        return this;
    }

    public WarpUplinkModem onUnlink(OnUnlinkRequest onUnlink) {
        this.observe(onUnlink);
        return this;
    }

    public WarpUplinkModem onUnlinked(OnUnlinkedResponse onUnlinked) {
        this.observe(onUnlinked);
        return this;
    }

    public WarpUplinkModem didClose(DidClose didClose) {
        this.observe(didClose);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnEvent(EventMessage message) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnEventMessage) {
                    try {
                        ((OnEventMessage)observers).onEvent(message);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnEventMessage)) continue;
                        try {
                            ((OnEventMessage)observer).onEvent(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnCommand(CommandMessage message, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnCommandMessage)) break block12;
                        if (((OnCommandMessage)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnCommandMessage)observers).onCommand(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnCommandMessage)) continue;
                        if (((OnCommandMessage)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnCommandMessage)observer).onCommand(message);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnLink(LinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnLinkRequest)) break block12;
                        if (((OnLinkRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnLinkRequest)observers).onLink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLinkRequest)) continue;
                        if (((OnLinkRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnLinkRequest)observer).onLink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnLinked(LinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnLinkedResponse) {
                    try {
                        ((OnLinkedResponse)observers).onLinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLinkedResponse)) continue;
                        try {
                            ((OnLinkedResponse)observer).onLinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnSync(SyncRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnSyncRequest)) break block12;
                        if (((OnSyncRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnSyncRequest)observers).onSync(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSyncRequest)) continue;
                        if (((OnSyncRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnSyncRequest)observer).onSync(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnSynced(SyncedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnSyncedResponse) {
                    try {
                        ((OnSyncedResponse)observers).onSynced(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSyncedResponse)) continue;
                        try {
                            ((OnSyncedResponse)observer).onSynced(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnUnlink(UnlinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnUnlinkRequest)) break block12;
                        if (((OnUnlinkRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnUnlinkRequest)observers).onUnlink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlinkRequest)) continue;
                        if (((OnUnlinkRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnUnlinkRequest)observer).onUnlink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnUnlinked(UnlinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnUnlinkedResponse) {
                    try {
                        ((OnUnlinkedResponse)observers).onUnlinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlinkedResponse)) continue;
                        try {
                            ((OnUnlinkedResponse)observer).onUnlinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchDidClose() {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof DidClose) {
                    try {
                        ((DidClose)observers).didClose();
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClose)) continue;
                        try {
                            ((DidClose)observer).didClose();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    protected boolean downQueueIsEmpty() {
        return true;
    }

    protected void queueDown(Value body) {
        throw new UnsupportedOperationException();
    }

    protected Value nextDownQueue() {
        return null;
    }

    protected EventMessage nextDownQueueEvent() {
        Value body = this.nextDownQueue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    protected Value nextDownCue() {
        return null;
    }

    protected EventMessage nextDownCueEvent() {
        Value body = this.nextDownCue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    public void sendDown(Value body) {
        int newStatus;
        int oldStatus;
        this.queueDown(body);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x20)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.linkBinding.feedDown();
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cueDown() {
        while (true) {
            int newStatus;
            int oldStatus;
            if (((oldStatus = this.status) & 1) != 0) {
                newStatus = oldStatus | 0x30;
                if (oldStatus == newStatus) return;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                if ((oldStatus & 0x20) != 0) return;
                this.linkBinding.feedDown();
                return;
            }
            newStatus = oldStatus | 0x10;
            if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) return;
        }
    }

    @Override
    public void pullDown() {
        this.stage().execute((Runnable)new WarpUplinkModemPullDown(this));
    }

    protected void runPullDown() {
        try {
            this.pullDownEnvelope();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void pullDownEnvelope() {
        block11: {
            int newStatus;
            int oldStatus;
            block14: {
                block13: {
                    block12: {
                        while (true) {
                            if (((oldStatus = this.status) & 8) != 0) {
                                newStatus = oldStatus & 0xFFFFFFF7;
                                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                                UnlinkedResponse response = this.unlinkedResponse();
                                this.pullDownUnlinked(response);
                                this.pushDown((Envelope)response);
                                break block11;
                            }
                            if ((oldStatus & 2) == 0) break block12;
                            newStatus = oldStatus & 0xFFFFFFFD;
                            if (STATUS.compareAndSet(this, oldStatus, newStatus)) break;
                        }
                        LinkedResponse response = this.linkedResponse();
                        this.pullDownLinked(response);
                        this.pushDown((Envelope)response);
                        if ((newStatus & 4) != 0) {
                            this.linkBinding.feedDown();
                        } else {
                            while (((oldStatus = this.status) & 0x10) == 0 && this.downQueueIsEmpty()) {
                                newStatus = oldStatus & 0xFFFFFFDF;
                                if (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                                break block11;
                            }
                            this.linkBinding.feedDown();
                        }
                        break block11;
                    }
                    EventMessage message = this.nextDownQueueEvent();
                    if (message == null && (oldStatus & 0x10) != 0) {
                        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFEF) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                        }
                        message = this.nextDownCueEvent();
                    }
                    if (message == null) break block13;
                    this.pullDownEvent(message);
                    this.pushDown((Envelope)message);
                    while (true) {
                        if (((oldStatus = this.status) & 0x14) == 0 && this.downQueueIsEmpty()) {
                            newStatus = oldStatus & 0xFFFFFFDF;
                            boolean statusHasChanged = STATUS.compareAndSet(this, oldStatus, newStatus);
                            if (!this.downQueueIsEmpty() || oldStatus != newStatus && !statusHasChanged) continue;
                            break block11;
                        }
                        newStatus = oldStatus | 0x20;
                        if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) break;
                    }
                    this.linkBinding.feedDown();
                    break block11;
                }
                if ((oldStatus & 4) == 0) break block14;
                SyncedResponse response = this.syncedResponse();
                this.pullDownSynced(response);
                this.pushDown((Envelope)response);
                while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = this.status) & 0x10) == 0 && this.downQueueIsEmpty() ? oldStatus & 0xFFFFFFDB : oldStatus & 0xFFFFFFFB)) {
                }
                if ((newStatus & 0x20) == 0) break block11;
                this.linkBinding.feedDown();
                break block11;
            }
            this.linkBinding.skipDown();
            while (((oldStatus = this.status) & 0x10) == 0 && this.downQueueIsEmpty()) {
                newStatus = oldStatus & 0xFFFFFFDF;
                if (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                break block11;
            }
            if ((oldStatus & 0x20) == 0) break block11;
            this.linkBinding.feedDown();
        }
    }

    protected void pullDownEvent(EventMessage message) {
        this.onEvent(message);
        this.dispatchOnEvent(message);
    }

    protected void pullDownLinked(LinkedResponse response) {
        this.didLink(response);
        this.dispatchOnLinked(response);
    }

    protected void pullDownSynced(SyncedResponse response) {
        this.didSync(response);
        this.dispatchOnSynced(response);
    }

    protected void pullDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
        this.dispatchOnUnlinked(response);
    }

    protected void pushDown(Envelope envelope) {
        this.linkBinding.pushDown(new Push<Envelope>(Uri.empty(), this.hostUri(), this.nodeUri(), this.laneUri(), this.prio(), null, envelope, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cueUp() {
        while (true) {
            int newStatus;
            int oldStatus;
            if (((oldStatus = this.status) & 0x40) != 0) {
                newStatus = oldStatus & 0xFFFFFFBF | 0x80;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.linkBinding.pullUp();
                return;
            }
            newStatus = oldStatus & 0xFFFFFF7F;
            if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void feedUp() {
        while (true) {
            int newStatus;
            int oldStatus;
            if (((oldStatus = this.status) & 0x80) == 0) {
                newStatus = oldStatus & 0xFFFFFFBF | 0x80;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.linkBinding.pullUp();
                return;
            }
            newStatus = oldStatus | 0x40;
            if (oldStatus == newStatus || STATUS.compareAndSet(this, oldStatus, newStatus)) return;
        }
    }

    @Override
    public void pushUp(Push<?> push) {
        Object message = push.message();
        if (message instanceof CommandMessage) {
            this.pushUpCommand(push);
        } else if (message instanceof LinkRequest) {
            this.pushUpLink(push);
        } else if (message instanceof SyncRequest) {
            this.pushUpSync(push);
        } else if (message instanceof UnlinkRequest) {
            this.pushUpUnlink(push);
        } else if (message instanceof Envelope) {
            this.pushUpUnknown(push);
        }
    }

    protected void pushUpCommand(Push<CommandMessage> push) {
        CommandMessage message = push.message();
        this.onCommand(message);
        this.laneBinding().pushUpCommand(push);
        if (!this.dispatchOnCommand(message, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnCommand(this, push));
        } else {
            this.cueUp();
        }
    }

    protected void runOnCommand(Push<CommandMessage> push) {
        block6: {
            try {
                this.dispatchOnCommand(push.message(), false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpLink(Push<LinkRequest> push) {
        LinkRequest request = push.message();
        this.willLink(request);
        if (!this.dispatchOnLink(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnLink(this, push));
        } else {
            push.bind();
            this.cueUp();
        }
    }

    protected void runOnLink(Push<LinkRequest> push) {
        block6: {
            try {
                this.dispatchOnLink(push.message(), false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                push.bind();
                this.cueUp();
            }
        }
    }

    protected void pushUpSync(Push<SyncRequest> push) {
        SyncRequest request = push.message();
        this.willSync(request);
        if (!this.dispatchOnSync(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnSync(this, push));
        } else {
            push.bind();
            this.cueUp();
        }
    }

    protected void runOnSync(Push<SyncRequest> push) {
        block6: {
            try {
                this.dispatchOnSync(push.message(), false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                push.bind();
                this.cueUp();
            }
        }
    }

    protected void pushUpUnlink(Push<UnlinkRequest> push) {
        UnlinkRequest request = push.message();
        this.willUnlink(request);
        if (!this.dispatchOnUnlink(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnUnlink(this, push));
        } else {
            push.bind();
        }
    }

    protected void runOnUnlink(Push<UnlinkRequest> push) {
        block6: {
            try {
                this.dispatchOnUnlink(push.message(), false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                push.bind();
            }
        }
    }

    protected void pushUpUnknown(Push<?> push) {
        push.bind();
        this.cueUp();
    }

    @Override
    public void skipUp() {
        this.cueUp();
    }

    public void unlink() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFF8 | 0x28)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            if ((oldStatus & 0x20) != 0) break;
            this.linkBinding.feedDown();
            break;
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void onEvent(EventMessage message) {
        EVENT_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void onCommand(CommandMessage message) {
        COMMAND_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void willLink(LinkRequest request) {
        block2: {
            int newStatus;
            int oldStatus;
            while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x23 : oldStatus | 0x23) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
            }
            if ((oldStatus & 0x20) == 0) {
                this.linkBinding.feedDown();
            }
            if ((oldStatus & 0x40) == 0) break block2;
            this.linkBinding.pullUp();
        }
    }

    protected void didLink(LinkedResponse response) {
    }

    protected void willSync(SyncRequest request) {
        block4: {
            int newStatus;
            int oldStatus;
            do {
                if (((oldStatus = this.status) & 1) == 0) {
                    if ((oldStatus & 0x40) == 0) {
                        newStatus = oldStatus & 0xFFFFFF7F | 0x27;
                        continue;
                    }
                    newStatus = oldStatus | 0x27;
                    continue;
                }
                newStatus = (oldStatus & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x24 : oldStatus | 0x24;
            } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
            if ((oldStatus & 0x20) == 0) {
                this.linkBinding.feedDown();
            }
            if ((oldStatus & 0x40) == 0) break block4;
            this.linkBinding.pullUp();
        }
    }

    protected void didSync(SyncedResponse response) {
    }

    protected void willUnlink(UnlinkRequest request) {
        block2: {
            int newStatus;
            int oldStatus;
            while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF78 | 0x28 : oldStatus & 0xFFFFFFF8 | 0x28) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
            }
            if ((oldStatus & 0x20) == 0) {
                this.linkBinding.feedDown();
            }
            if ((oldStatus & 0x40) == 0) break block2;
            this.linkBinding.pullUp();
        }
    }

    protected void didUnlink(UnlinkedResponse response) {
        this.close();
    }

    protected LinkedResponse linkedResponse() {
        return new LinkedResponse(this.nodeUri(), this.laneUri(), this.prio(), this.rate(), this.body());
    }

    protected SyncedResponse syncedResponse() {
        return new SyncedResponse(this.nodeUri(), this.laneUri());
    }

    protected UnlinkedResponse unlinkedResponse() {
        return new UnlinkedResponse(this.nodeUri(), this.laneUri());
    }

    @Override
    protected void didClose() {
        super.didClose();
        this.dispatchDidClose();
        this.flushMetrics();
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.laneBinding().openMetaUplink(uplink, metaUplink);
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = this.lastReportTime)) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        WarpUplinkProfile profile = this.collectProfile(dt);
        this.laneBinding().reportDown(profile);
    }

    protected WarpUplinkProfile collectProfile(long dt) {
        int eventDelta = EVENT_DELTA.getAndSet(this, 0);
        int eventRate = (int)Math.ceil(1000.0 * (double)eventDelta / (double)dt);
        long eventCount = EVENT_COUNT.addAndGet(this, eventDelta);
        int commandDelta = COMMAND_DELTA.getAndSet(this, 0);
        int commandRate = (int)Math.ceil(1000.0 * (double)commandDelta / (double)dt);
        long commandCount = COMMAND_TOTAL.addAndGet(this, commandDelta);
        return new WarpUplinkProfile(this.uplinkAddress, eventDelta, eventRate, eventCount, commandDelta, commandRate, commandCount);
    }
}

