/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.runtime.AbstractSwimRef;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;

public abstract class AbstractTierBinding
extends AbstractSwimRef
implements TierBinding {
    protected volatile int status;
    protected static final int STATE_MASK = 15;
    protected static final int CLOSED_STATE = 0;
    protected static final int CLOSING_STATE = 1;
    protected static final int UNLOADING_STATE = 2;
    protected static final int STOPPING_STATE = 3;
    protected static final int RECOVERING_STATE = 4;
    protected static final int FAILING_STATE = 5;
    protected static final int FAILED_STATE = 6;
    protected static final int OPENING_STATE = 7;
    protected static final int OPENED_STATE = 8;
    protected static final int LOADING_STATE = 9;
    protected static final int LOADED_STATE = 10;
    protected static final int STARTING_STATE = 11;
    protected static final int STARTED_STATE = 12;
    protected static final int PHASE_SHIFT = 4;
    protected static final int PHASE_MASK = 240;
    protected static final int CLOSED_PHASE = 0;
    protected static final int OPENED_PHASE = 1;
    protected static final int LOADED_PHASE = 2;
    protected static final int STARTED_PHASE = 3;
    protected static final AtomicIntegerFieldUpdater<AbstractTierBinding> STATUS = AtomicIntegerFieldUpdater.newUpdater(AbstractTierBinding.class, "status");

    @Override
    public abstract TierContext tierContext();

    @Override
    public boolean isClosed() {
        int state = this.status & 0xF;
        return state == 0;
    }

    @Override
    public boolean isOpened() {
        int state = this.status & 0xF;
        return state >= 8;
    }

    @Override
    public boolean isLoaded() {
        int state = this.status & 0xF;
        return state >= 10;
    }

    @Override
    public boolean isStarted() {
        int state = this.status & 0xF;
        return state == 12;
    }

    protected void activate(TierBinding childTier) {
        int state = this.status & 0xF;
        if (state >= 11) {
            childTier.start();
        } else if (state >= 9) {
            childTier.load();
        } else if (state >= 7) {
            childTier.open();
        }
    }

    @Override
    public void open() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        boolean newPhase = true;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (1 <= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 0 ? 7 : oldState;
            newStatus = newState & 0xF | 0x10;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState && newState == 7) {
            this.willOpen();
            this.convergeState();
        }
    }

    @Override
    public void load() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        int newPhase = 2;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (2 <= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 8 ? 9 : (oldState == 0 ? 7 : oldState);
            newStatus = newState & 0xF | 0x20;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState) {
            if (newState == 9) {
                this.willLoad();
                this.convergeState();
            } else if (newState == 7) {
                this.willOpen();
                this.convergeState();
            }
        }
    }

    @Override
    public void start() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        int newPhase = 3;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (3 <= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 10 ? 11 : (oldState == 8 ? 9 : (oldState == 0 ? 7 : oldState));
            newStatus = newState & 0xF | 0x30;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState) {
            if (newState == 11) {
                this.willStart();
                this.convergeState();
            } else if (newState == 9) {
                this.willLoad();
                this.convergeState();
            } else if (newState == 7) {
                this.willOpen();
                this.convergeState();
            }
        }
    }

    @Override
    public void stop() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        int newPhase = 2;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (2 >= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 12 ? 3 : oldState;
            newStatus = newState & 0xF | 0x20;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState && newState == 3) {
            this.willStop();
            this.convergeState();
        }
    }

    @Override
    public void unload() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        boolean newPhase = true;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (1 >= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 10 ? 2 : (oldState == 12 ? 3 : oldState);
            newStatus = newState & 0xF | 0x10;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState) {
            if (newState == 2) {
                this.willUnload();
                this.convergeState();
            } else if (newState == 3) {
                this.willStop();
                this.convergeState();
            }
        }
    }

    @Override
    public void close() {
        int newState;
        int oldState;
        int newStatus;
        int oldStatus;
        boolean newPhase = false;
        do {
            oldStatus = this.status;
            oldState = oldStatus & 0xF;
            int oldPhase = (oldStatus & 0xF0) >>> 4;
            if (0 >= oldPhase) {
                newState = oldState;
                newStatus = oldStatus;
                break;
            }
            newState = oldState == 8 ? 1 : (oldState == 10 ? 2 : (oldState == 12 ? 3 : oldState));
            newStatus = newState & 0xF | 0;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if (oldState != newState) {
            if (newState == 1) {
                this.willClose();
                this.convergeState();
            } else if (newState == 2) {
                this.willUnload();
                this.convergeState();
            } else if (newState == 3) {
                this.willStop();
                this.convergeState();
            }
        }
    }

    void convergeState() {
        block24: while (true) {
            int newState;
            int oldState;
            block25: {
                int newStatus;
                int oldStatus = this.status;
                oldState = oldStatus & 0xF;
                int phase = (oldStatus & 0xF0) >>> 4;
                switch (oldState) {
                    case 7: {
                        newState = phase > 1 ? 9 : (phase < 1 ? 1 : 8);
                        break;
                    }
                    case 9: {
                        newState = phase > 2 ? 11 : (phase < 2 ? 2 : 10);
                        break;
                    }
                    case 11: {
                        newState = phase < 3 ? 3 : 12;
                        break;
                    }
                    case 3: {
                        newState = phase < 2 ? 2 : (phase > 2 ? 11 : 10);
                        break;
                    }
                    case 2: {
                        newState = phase < 1 ? 1 : (phase > 1 ? 9 : 8);
                        break;
                    }
                    case 1: {
                        newState = phase > 0 ? 7 : 0;
                        break;
                    }
                    default: {
                        newState = oldState;
                        newStatus = oldStatus;
                        break block25;
                    }
                }
                if (oldStatus != (newStatus = oldStatus & 0xFFFFFFF0 | newState & 0xF) && !STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            }
            if (oldState == newState) continue;
            switch (oldState) {
                case 7: {
                    this.didOpen();
                    break;
                }
                case 9: {
                    this.didLoad();
                    break;
                }
                case 11: {
                    this.didStart();
                    break;
                }
                case 3: {
                    this.didStop();
                    break;
                }
                case 2: {
                    this.didUnload();
                    break;
                }
                case 1: {
                    TierContext tierContext = this.tierContext();
                    if (tierContext == null) break;
                    tierContext.close();
                    break;
                }
            }
            switch (newState) {
                case 7: {
                    this.willOpen();
                    continue block24;
                }
                case 9: {
                    this.willLoad();
                    continue block24;
                }
                case 11: {
                    this.willStart();
                    continue block24;
                }
                case 3: {
                    this.willStop();
                    continue block24;
                }
                case 2: {
                    this.willUnload();
                    continue block24;
                }
                case 1: {
                    this.willClose();
                    continue block24;
                }
            }
            break;
        }
    }

    protected void willOpen() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willOpen();
        }
    }

    protected void didOpen() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.didOpen();
        }
    }

    protected void willLoad() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willLoad();
        }
    }

    protected void didLoad() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.didLoad();
        }
    }

    protected void willStart() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willStart();
        }
    }

    protected void didStart() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.didStart();
        }
    }

    protected void willStop() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willStop();
        }
    }

    protected void didStop() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.didStop();
        }
    }

    protected void willUnload() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willUnload();
        }
    }

    protected void didUnload() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.didUnload();
        }
    }

    protected void willClose() {
        TierContext tierContext = this.tierContext();
        if (tierContext != null) {
            tierContext.willClose();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

