/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Uplink;
import swim.api.auth.Identity;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.UplinkAddress;
import swim.structure.Value;
import swim.uri.Uri;

public abstract class AbstractUplinkContext
implements LinkContext,
Uplink {
    static final AtomicReferenceFieldUpdater<AbstractUplinkContext, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(AbstractUplinkContext.class, Object.class, "observers");
    protected volatile Object observers;

    public abstract LaneBinding laneBinding();

    @Override
    public abstract LinkBinding linkWrapper();

    public abstract LinkBinding linkBinding();

    @Override
    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T> T bottomLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public abstract Stage stage();

    public abstract Uri hostUri();

    public abstract Uri nodeUri();

    public abstract Uri laneUri();

    @Override
    public abstract Value linkKey();

    @Override
    public UplinkAddress cellAddressUp() {
        return this.laneBinding().cellAddress().linkKey(this.linkKey());
    }

    @Override
    public boolean isConnectedUp() {
        return true;
    }

    @Override
    public boolean isRemoteUp() {
        return false;
    }

    @Override
    public boolean isSecureUp() {
        return true;
    }

    @Override
    public String securityProtocolUp() {
        return null;
    }

    @Override
    public String cipherSuiteUp() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressUp() {
        return null;
    }

    @Override
    public Identity localIdentityUp() {
        return null;
    }

    @Override
    public Principal localPrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressUp() {
        return null;
    }

    @Override
    public Identity remoteIdentityUp() {
        return null;
    }

    @Override
    public Principal remotePrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    public boolean isConnected() {
        return this.linkBinding().isConnectedDown();
    }

    public boolean isRemote() {
        return this.linkBinding().isRemoteDown();
    }

    public boolean isSecure() {
        return this.linkBinding().isSecureDown();
    }

    public String securityProtocol() {
        return this.linkBinding().securityProtocolDown();
    }

    public String cipherSuite() {
        return this.linkBinding().cipherSuiteDown();
    }

    public InetSocketAddress localAddress() {
        return this.linkBinding().localAddressDown();
    }

    public Identity localIdentity() {
        return this.linkBinding().localIdentityDown();
    }

    public Principal localPrincipal() {
        return this.linkBinding().localPrincipalDown();
    }

    public Collection<Certificate> localCertificates() {
        return this.linkBinding().localCertificatesDown();
    }

    public InetSocketAddress remoteAddress() {
        return this.linkBinding().remoteAddressDown();
    }

    public Identity remoteIdentity() {
        return this.linkBinding().remoteIdentityDown();
    }

    public Principal remotePrincipal() {
        return this.linkBinding().remotePrincipalDown();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.linkBinding().remoteCertificatesDown();
    }

    public AbstractUplinkContext observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public AbstractUplinkContext unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    @Override
    public void closeUp() {
        this.didClose();
    }

    public void close() {
        this.closeUp();
    }

    @Override
    public void didOpenDown() {
    }

    @Override
    public void didCloseDown() {
        this.didClose();
    }

    protected void didClose() {
        this.laneBinding().closeUplink(this.linkKey());
    }

    @Override
    public void didFailDown(Throwable error) {
        try {
            if (Conts.isNonFatal((Throwable)error)) {
                this.laneBinding().didFail(error);
            }
        }
        finally {
            this.didClose();
        }
    }

    protected void didFail(Throwable error) {
        this.laneBinding().didFail(error);
    }

    @Override
    public void traceUp(Object message) {
        this.laneBinding().trace(message);
    }

    @Override
    public void debugUp(Object message) {
        this.laneBinding().debug(message);
    }

    @Override
    public void infoUp(Object message) {
        this.laneBinding().info(message);
    }

    @Override
    public void warnUp(Object message) {
        this.laneBinding().warn(message);
    }

    @Override
    public void errorUp(Object message) {
        this.laneBinding().error(message);
    }

    @Override
    public void failUp(Object message) {
        this.laneBinding().fail(message);
    }

    public void trace(Object message) {
        this.linkBinding().traceDown(message);
    }

    public void debug(Object message) {
        this.linkBinding().debugDown(message);
    }

    public void info(Object message) {
        this.linkBinding().infoDown(message);
    }

    public void warn(Object message) {
        this.linkBinding().warnDown(message);
    }

    public void error(Object message) {
        this.linkBinding().errorDown(message);
    }

    public void fail(Object message) {
        this.linkBinding().failDown(message);
    }
}

