/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.CellAddress;
import swim.runtime.LinkAddress;
import swim.structure.Value;
import swim.util.Murmur3;

public final class DownlinkAddress
implements LinkAddress,
Debug {
    final CellAddress cellAddress;
    final Value linkKey;
    private static int hashSeed;

    public DownlinkAddress(CellAddress cellAddress, Value linkKey) {
        this.cellAddress = cellAddress;
        this.linkKey = linkKey.commit();
    }

    public CellAddress cellAddress() {
        return this.cellAddress;
    }

    public DownlinkAddress cellAddress(CellAddress cellAddress) {
        return this.copy(cellAddress, this.linkKey);
    }

    public Value linkKey() {
        return this.linkKey;
    }

    public DownlinkAddress linkKey(Value linkKey) {
        return this.copy(this.cellAddress, linkKey);
    }

    DownlinkAddress copy(CellAddress cellAddress, Value linkKey) {
        return new DownlinkAddress(cellAddress, linkKey);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DownlinkAddress) {
            DownlinkAddress that = (DownlinkAddress)other;
            return this.cellAddress.equals(that.cellAddress) && this.linkKey.equals((Object)that.linkKey);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(DownlinkAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.cellAddress.hashCode()), (int)this.linkKey.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("DownlinkAddress").write(46).write("from").write(40).debug((Object)this.cellAddress.toString()).write(", ").debug((Object)this.linkKey).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static DownlinkAddress from(CellAddress cellAddress, Value linkKey) {
        return new DownlinkAddress(cellAddress, linkKey);
    }
}

