/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Conts;
import swim.runtime.AbstractDownlinkBinding;
import swim.runtime.DownlinkRelayDidClose;
import swim.runtime.DownlinkRelayDidConnect;
import swim.runtime.DownlinkRelayDidDisconnect;
import swim.runtime.DownlinkRelayDidFail;
import swim.runtime.DownlinkView;
import swim.runtime.LinkBinding;
import swim.uri.Uri;

public abstract class DownlinkModel<View extends DownlinkView>
extends AbstractDownlinkBinding
implements LinkBinding {
    protected volatile Object views;
    static final AtomicReferenceFieldUpdater<DownlinkModel<?>, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(DownlinkModel.class, Object.class, "views");

    public DownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri) {
        super(meshUri, hostUri, nodeUri, laneUri);
    }

    public void addDownlink(View view) {
        Object newViews;
        Object oldViews;
        do {
            if ((oldViews = this.views) instanceof DownlinkView) {
                newViews = new DownlinkView[]{(DownlinkView)oldViews, view};
                continue;
            }
            if (oldViews instanceof DownlinkView[]) {
                DownlinkView[] oldViewArray = (DownlinkView[])oldViews;
                int n = oldViewArray.length;
                DownlinkView[] newViewArray = new DownlinkView[n + 1];
                System.arraycopy(oldViewArray, 0, newViewArray, 0, n);
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.didAddDownlink(view);
        if (oldViews == null) {
            this.openDown();
        }
    }

    public void removeDownlink(View view) {
        DownlinkView[] newViews;
        DownlinkView[] oldViews;
        do {
            if ((oldViews = this.views) instanceof DownlinkView) {
                if (oldViews == view) {
                    newViews = null;
                    continue;
                }
            } else if (oldViews instanceof DownlinkView[]) {
                DownlinkView[] oldViewArray = oldViews;
                int n = oldViewArray.length;
                if (n == 2) {
                    if (oldViewArray[0] == view) {
                        newViews = oldViewArray[1];
                        continue;
                    }
                    if (oldViewArray[1] == view) {
                        newViews = oldViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    DownlinkView[] newViewArray = new DownlinkView[n - 1];
                    for (i = 0; i < n && oldViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newViewArray[i] = oldViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldViewArray, i + 1, newViewArray, i, n - (i + 1));
                        newViews = newViewArray;
                        continue;
                    }
                }
            }
            newViews = oldViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        if (oldViews != newViews) {
            this.didRemoveDownlink(view);
        }
        if (newViews == null) {
            this.closeDown();
        }
    }

    protected void removeDownlinks() {
        Object views = VIEWS.getAndSet(this, null);
        if (views instanceof DownlinkView) {
            DownlinkView view = views;
            this.didRemoveDownlink(view);
        } else if (views instanceof DownlinkView[]) {
            for (DownlinkView view : (DownlinkView[])views) {
                this.didRemoveDownlink(view);
            }
        }
    }

    protected void didAddDownlink(View view) {
    }

    protected void didRemoveDownlink(View view) {
    }

    @Override
    public void reopen() {
        Object views = this.views;
        if (views instanceof DownlinkView) {
            DownlinkView view = (DownlinkView)views;
            view.close();
            view.open();
        } else if (views instanceof DownlinkView[]) {
            DownlinkView view;
            int i;
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = ((DownlinkView[])views).length;
            for (i = 0; i < n; ++i) {
                view = viewArray[i];
                view.close();
            }
            for (i = 0; i < n; ++i) {
                view = viewArray[i];
                view.open();
            }
        }
    }

    @Override
    public void didConnect() {
        new DownlinkRelayDidConnect(this).run();
    }

    @Override
    public void didDisconnect() {
        new DownlinkRelayDidDisconnect(this).run();
    }

    @Override
    public void didCloseUp() {
        new DownlinkRelayDidClose(this).run();
    }

    @Override
    public void didFail(Throwable error) {
        if (Conts.isNonFatal((Throwable)error)) {
            new DownlinkRelayDidFail(this, error).run();
        } else {
            error.printStackTrace();
        }
    }

    public void accumulateExecTime(long execDelta) {
    }
}

