/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.PartPredicate;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

final class HashPartPredicate
extends PartPredicate {
    private static int hashSeed;
    final int lowerBound;
    final int upperBound;

    HashPartPredicate(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static HashPartPredicate fromValue(Value value) {
        Value header = value.getAttr("hash");
        int lowerBound = header.getItem(0).intValue();
        int upperBound = header.getItem(1).intValue();
        return new HashPartPredicate(lowerBound, upperBound);
    }

    @Override
    public boolean test(Uri nodeUri, int nodeHash) {
        long dlh = (long)(nodeHash - this.lowerBound) & 0xFFFFFFFFL;
        return 0L <= dlh && dlh < ((long)(this.upperBound - this.lowerBound) & 0xFFFFFFFFL);
    }

    @Override
    public Value toValue() {
        return Record.create((int)1).attr("hash", (Value)Record.create((int)2).item(this.lowerBound).item(this.upperBound));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HashPartPredicate) {
            HashPartPredicate that = (HashPartPredicate)other;
            return this.lowerBound == that.lowerBound && this.upperBound == that.upperBound;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HashPartPredicate.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lowerBound), (int)this.upperBound));
    }

    public String toString() {
        return "PartPredicate.hash(" + this.lowerBound + ", " + this.upperBound + ")";
    }
}

