/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.HostAddressed;
import swim.runtime.MeshAddressed;
import swim.runtime.NodeAddress;
import swim.runtime.PartAddressed;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class HostAddress
implements EdgeAddressed,
MeshAddressed,
PartAddressed,
HostAddressed,
Debug {
    final String edgeName;
    final Uri meshUri;
    final Value partKey;
    final Uri hostUri;
    private static int hashSeed;

    public HostAddress(String edgeName, Uri meshUri, Value partKey, Uri hostUri) {
        this.edgeName = edgeName;
        this.meshUri = meshUri;
        this.partKey = partKey.commit();
        this.hostUri = hostUri;
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    @Override
    public Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public HostAddress meshUri(Uri meshUri) {
        return this.copy(this.edgeName, meshUri, this.partKey, this.hostUri);
    }

    @Override
    public HostAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    @Override
    public Value partKey() {
        return this.partKey;
    }

    @Override
    public HostAddress partKey(Value partKey) {
        return this.copy(this.edgeName, this.meshUri, partKey, this.hostUri);
    }

    @Override
    public Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public HostAddress hostUri(Uri hostUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, hostUri);
    }

    @Override
    public HostAddress hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    HostAddress copy(String edgeName, Uri meshUri, Value partKey, Uri hostUri) {
        return new HostAddress(edgeName, meshUri, partKey, hostUri);
    }

    @Override
    public NodeAddress nodeUri(Uri nodeUri) {
        return new NodeAddress(this.edgeName, this.meshUri, this.partKey, this.hostUri, nodeUri);
    }

    @Override
    public NodeAddress nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostAddress) {
            HostAddress that = (HostAddress)other;
            return this.edgeName.equals(that.edgeName) && this.meshUri.equals((Object)that.meshUri) && this.partKey.equals((Object)that.partKey) && this.hostUri.equals((Object)that.hostUri);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(HostAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()), (int)this.meshUri.hashCode()), (int)this.partKey.hashCode()), (int)this.hostUri.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HostAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(", ").debug((Object)this.meshUri.toString()).write(", ").debug((Object)this.partKey).write(", ").debug((Object)this.hostUri.toString()).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HostAddress from(String edgeName, Uri meshUri, Value partKey, Uri hostUri) {
        return new HostAddress(edgeName, meshUri, partKey, hostUri);
    }

    public static HostAddress from(String edgeName, String meshUri, Value partKey, String hostUri) {
        return new HostAddress(edgeName, Uri.parse((String)meshUri), partKey, Uri.parse((String)hostUri));
    }
}

