/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneModel;
import swim.runtime.LaneView;

public abstract class LaneRelay<Model extends LaneModel<View, ?>, View extends LaneView>
implements Runnable {
    protected final Model model;
    protected final Object views;
    protected final int viewCount;
    protected final int phaseCount;
    protected int viewIndex;
    protected int phase;
    protected boolean preemptive;
    protected Stage stage;

    protected LaneRelay(Model model, int minPhase, int phaseCount, Stage stage) {
        this.model = model;
        this.views = ((LaneModel)model).views;
        this.viewCount = this.views instanceof LaneView ? 1 : (this.views instanceof LaneView[] ? ((LaneView[])this.views).length : 0);
        this.phase = minPhase;
        this.phaseCount = phaseCount;
        this.preemptive = true;
        this.stage = stage;
        this.beginPhase(this.phase);
    }

    protected LaneRelay(Model model, int phaseCount) {
        this(model, 0, phaseCount, null);
    }

    protected LaneRelay(Model model) {
        this(model, 0, 1, null);
    }

    public boolean isDone() {
        return this.phase > this.phaseCount;
    }

    protected void beginPhase(int phase) {
    }

    protected boolean runPhase(View view, int phase, boolean preemptive) {
        return true;
    }

    protected void endPhase(int phase) {
    }

    protected void done() {
    }

    void pass() {
        while (this.phase < this.phaseCount) {
            this.endPhase(this.phase);
            ++this.phase;
            this.preemptive = true;
            if (this.phase < this.phaseCount) {
                this.beginPhase(this.phase);
                continue;
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            break;
        }
    }

    void pass(View view) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    block5: {
                        try {
                            if (this.runPhase(view, this.phase, this.preemptive) || !this.preemptive) break block5;
                            this.preemptive = false;
                            if (this.stage != null) continue;
                            this.stage = ((LaneModel)this.model).stage();
                            this.stage.execute((Runnable)this);
                            break block6;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                ((LaneView)view).laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
        }
    }

    void pass(LaneView[] views) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    block5: {
                        LaneView view = views[this.viewIndex];
                        try {
                            if (this.runPhase(view, this.phase, this.preemptive) || !this.preemptive) break block5;
                            this.preemptive = false;
                            if (this.stage != null) continue;
                            this.stage = ((LaneModel)this.model).stage();
                            this.stage.execute((Runnable)this);
                            break block6;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                view.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
        }
    }

    @Override
    public void run() {
        Stage stage = this.stage;
        long t0 = System.nanoTime();
        try {
            if (this.viewCount == 0) {
                this.pass();
            } else if (this.viewCount == 1) {
                this.pass((LaneView)this.views);
            } else if (this.viewCount > 1) {
                this.pass((LaneView[])this.views);
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                ((LaneModel)this.model).didFail(error);
            }
            throw error;
        }
        long dt = System.nanoTime() - t0;
        if (stage == null) {
            ((LaneModel)this.model).accumulateExecTime(dt);
        }
    }
}

