/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.HostAddressed;
import swim.runtime.LaneAddress;
import swim.runtime.MeshAddressed;
import swim.runtime.NodeAddressed;
import swim.runtime.PartAddressed;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class NodeAddress
implements EdgeAddressed,
MeshAddressed,
PartAddressed,
HostAddressed,
NodeAddressed,
Debug {
    final String edgeName;
    final Uri meshUri;
    final Value partKey;
    final Uri hostUri;
    final Uri nodeUri;
    private static int hashSeed;

    public NodeAddress(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        this.edgeName = edgeName;
        this.meshUri = meshUri;
        this.partKey = partKey.commit();
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    @Override
    public Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public NodeAddress meshUri(Uri meshUri) {
        return this.copy(this.edgeName, meshUri, this.partKey, this.hostUri, this.nodeUri);
    }

    @Override
    public NodeAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    @Override
    public Value partKey() {
        return this.partKey;
    }

    @Override
    public NodeAddress partKey(Value partKey) {
        return this.copy(this.edgeName, this.meshUri, partKey, this.hostUri, this.nodeUri);
    }

    @Override
    public Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public NodeAddress hostUri(Uri hostUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, hostUri, this.nodeUri);
    }

    @Override
    public NodeAddress hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public NodeAddress nodeUri(Uri nodeUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, this.hostUri, nodeUri);
    }

    @Override
    public NodeAddress nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    NodeAddress copy(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return new NodeAddress(edgeName, meshUri, partKey, hostUri, nodeUri);
    }

    @Override
    public LaneAddress laneUri(Uri laneUri) {
        return new LaneAddress(this.edgeName, this.meshUri, this.partKey, this.hostUri, this.nodeUri, laneUri);
    }

    @Override
    public LaneAddress laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NodeAddress) {
            NodeAddress that = (NodeAddress)other;
            return this.edgeName.equals(that.edgeName) && this.meshUri.equals((Object)that.meshUri) && this.partKey.equals((Object)that.partKey) && this.hostUri.equals((Object)that.hostUri) && this.nodeUri.equals((Object)that.nodeUri);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(NodeAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()), (int)this.meshUri.hashCode()), (int)this.partKey.hashCode()), (int)this.hostUri.hashCode()), (int)this.nodeUri.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("NodeAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(", ").debug((Object)this.meshUri.toString()).write(", ").debug((Object)this.partKey).write(", ").debug((Object)this.hostUri.toString()).write(", ").debug((Object)this.nodeUri).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static NodeAddress from(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return new NodeAddress(edgeName, meshUri, partKey, hostUri, nodeUri);
    }

    public static NodeAddress from(String edgeName, String meshUri, Value partKey, String hostUri, String nodeUri) {
        return new NodeAddress(edgeName, Uri.parse((String)meshUri), partKey, Uri.parse((String)hostUri), Uri.parse((String)nodeUri));
    }
}

