/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.runtime.CellBinding;
import swim.runtime.HostBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.NodeAddress;
import swim.runtime.NodeContext;
import swim.runtime.TierBinding;
import swim.structure.Value;
import swim.uri.Uri;

public interface NodeBinding
extends TierBinding,
CellBinding {
    public HostBinding host();

    public NodeBinding nodeWrapper();

    public NodeContext nodeContext();

    public void setNodeContext(NodeContext var1);

    public <T> T unwrapNode(Class<T> var1);

    public <T> T bottomNode(Class<T> var1);

    public NodeAddress cellAddress();

    public Uri meshUri();

    public Value partKey();

    public Uri hostUri();

    public Uri nodeUri();

    public long createdTime();

    public void openMetaNode(NodeBinding var1, NodeBinding var2);

    public FingerTrieSeq<Value> agentIds();

    public FingerTrieSeq<Agent> agents();

    public AgentFactory<?> createAgentFactory(NodeBinding var1, AgentDef var2);

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding var1, Class<? extends A> var2);

    public void openAgents(NodeBinding var1);

    public HashTrieMap<Uri, LaneBinding> lanes();

    public LaneBinding getLane(Uri var1);

    public LaneBinding openLane(Uri var1);

    public LaneBinding openLane(Uri var1, LaneBinding var2);

    public void openLanes(NodeBinding var1);

    public void openMetaLane(LaneBinding var1, NodeBinding var2);

    public void openMetaUplink(LinkBinding var1, NodeBinding var2);
}

