/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.HostAddressed;
import swim.runtime.LaneAddressed;
import swim.runtime.MeshAddressed;
import swim.runtime.NodeAddressed;
import swim.runtime.PartAddressed;
import swim.runtime.UplinkAddressed;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class UplinkAddress
implements EdgeAddressed,
MeshAddressed,
PartAddressed,
HostAddressed,
NodeAddressed,
LaneAddressed,
UplinkAddressed,
Debug {
    final String edgeName;
    final Uri meshUri;
    final Value partKey;
    final Uri hostUri;
    final Uri nodeUri;
    final Uri laneUri;
    final Value linkKey;
    private static int hashSeed;

    public UplinkAddress(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, Value linkKey) {
        this.edgeName = edgeName;
        this.meshUri = meshUri;
        this.partKey = partKey.commit();
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.linkKey = linkKey.commit();
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    @Override
    public Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public UplinkAddress meshUri(Uri meshUri) {
        return this.copy(this.edgeName, meshUri, this.partKey, this.hostUri, this.nodeUri, this.laneUri, this.linkKey);
    }

    @Override
    public UplinkAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    @Override
    public Value partKey() {
        return this.partKey;
    }

    @Override
    public UplinkAddress partKey(Value partKey) {
        return this.copy(this.edgeName, this.meshUri, partKey, this.hostUri, this.nodeUri, this.laneUri, this.linkKey);
    }

    @Override
    public Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public UplinkAddress hostUri(Uri hostUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, hostUri, this.nodeUri, this.laneUri, this.linkKey);
    }

    @Override
    public UplinkAddress hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public UplinkAddress nodeUri(Uri nodeUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, this.hostUri, nodeUri, this.laneUri, this.linkKey);
    }

    @Override
    public UplinkAddress nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    @Override
    public Uri laneUri() {
        return this.laneUri;
    }

    @Override
    public UplinkAddress laneUri(Uri laneUri) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, this.hostUri, this.nodeUri, laneUri, this.linkKey);
    }

    @Override
    public UplinkAddress laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    @Override
    public Value linkKey() {
        return this.linkKey;
    }

    @Override
    public UplinkAddress linkKey(Value linkKey) {
        return this.copy(this.edgeName, this.meshUri, this.partKey, this.hostUri, this.nodeUri, this.laneUri, linkKey);
    }

    UplinkAddress copy(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, Value linkKey) {
        return new UplinkAddress(edgeName, meshUri, partKey, hostUri, nodeUri, laneUri, linkKey);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UplinkAddress) {
            UplinkAddress that = (UplinkAddress)other;
            return this.edgeName.equals(that.edgeName) && this.meshUri.equals((Object)that.meshUri) && this.partKey.equals((Object)that.partKey) && this.hostUri.equals((Object)that.hostUri) && this.nodeUri.equals((Object)that.nodeUri) && this.laneUri.equals((Object)that.laneUri) && this.linkKey.equals((Object)that.linkKey);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(UplinkAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()), (int)this.meshUri.hashCode()), (int)this.partKey.hashCode()), (int)this.hostUri.hashCode()), (int)this.nodeUri.hashCode()), (int)this.laneUri.hashCode()), (int)this.linkKey.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("UplinkAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(", ").debug((Object)this.meshUri.toString()).write(", ").debug((Object)this.partKey).write(", ").debug((Object)this.hostUri.toString()).write(", ").debug((Object)this.nodeUri).write(", ").debug((Object)this.laneUri.toString()).write(", ").debug((Object)this.linkKey).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static UplinkAddress from(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, Value linkKey) {
        return new UplinkAddress(edgeName, meshUri, partKey, hostUri, nodeUri, laneUri, linkKey);
    }

    public static UplinkAddress from(String edgeName, String meshUri, Value partKey, String hostUri, String nodeUri, String laneUri, Value linkKey) {
        return new UplinkAddress(edgeName, Uri.parse((String)meshUri), partKey, Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri), linkKey);
    }
}

