/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.api.Downlink;
import swim.api.Lane;
import swim.api.auth.Identity;
import swim.api.lane.SupplyLane;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.Metric;
import swim.runtime.NodeBinding;
import swim.runtime.Push;
import swim.runtime.agent.AgentNode;
import swim.runtime.reflect.LogEntry;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class AgentLane
implements LaneContext {
    protected final AgentNode node;
    protected final LaneBinding lane;
    protected final LaneAddress laneAddress;
    SupplyLane<LogEntry> metaTraceLog;
    SupplyLane<LogEntry> metaDebugLog;
    SupplyLane<LogEntry> metaInfoLog;
    SupplyLane<LogEntry> metaWarnLog;
    SupplyLane<LogEntry> metaErrorLog;
    SupplyLane<LogEntry> metaFailLog;

    public AgentLane(AgentNode node, LaneBinding lane, LaneAddress laneAddress) {
        this.node = node;
        this.lane = lane;
        this.laneAddress = laneAddress;
    }

    @Override
    public final NodeBinding node() {
        return this.node;
    }

    @Override
    public final LaneBinding laneWrapper() {
        return this.lane.laneWrapper();
    }

    @Override
    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T> T bottomLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public final LaneAddress cellAddress() {
        return this.laneAddress;
    }

    @Override
    public final String edgeName() {
        return this.laneAddress.edgeName();
    }

    @Override
    public final Uri meshUri() {
        return this.laneAddress.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.laneAddress.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.laneAddress.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.laneAddress.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.laneAddress.laneUri();
    }

    @Override
    public final Identity identity() {
        return this.node.identity();
    }

    @Override
    public Policy policy() {
        return this.node.policy();
    }

    @Override
    public Schedule schedule() {
        return this.node;
    }

    @Override
    public Stage stage() {
        return this.node;
    }

    @Override
    public StoreBinding store() {
        return this.node.store();
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.openMetaLanes(lane, (AgentNode)metaLane);
        this.node.openMetaLane(lane, metaLane);
    }

    protected void openMetaLanes(LaneBinding lane, AgentNode metaLane) {
        this.openLogLanes(lane, metaLane);
    }

    protected void openLogLanes(LaneBinding lane, AgentNode metaLane) {
        this.metaTraceLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.TRACE_LOG_URI, (Lane)this.metaTraceLog);
        this.metaDebugLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.DEBUG_LOG_URI, (Lane)this.metaDebugLog);
        this.metaInfoLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.INFO_LOG_URI, (Lane)this.metaInfoLog);
        this.metaWarnLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.WARN_LOG_URI, (Lane)this.metaWarnLog);
        this.metaErrorLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.ERROR_LOG_URI, (Lane)this.metaErrorLog);
        this.metaFailLog = metaLane.supplyLane().valueForm(LogEntry.form());
        metaLane.openLane(LogEntry.FAIL_LOG_URI, (Lane)this.metaFailLog);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.node.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.node.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.node.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.node.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void pushDown(Push<?> push) {
        this.node.pushDown(push);
    }

    @Override
    public void reportDown(Metric metric) {
        this.node.reportDown(metric);
    }

    public void trace(Object message) {
        SupplyLane<LogEntry> metaTraceLog = this.metaTraceLog;
        if (metaTraceLog != null) {
            metaTraceLog.push((Object)LogEntry.trace(message));
        }
        this.node.trace(message);
    }

    public void debug(Object message) {
        SupplyLane<LogEntry> metaDebugLog = this.metaDebugLog;
        if (metaDebugLog != null) {
            metaDebugLog.push((Object)LogEntry.debug(message));
        }
        this.node.debug(message);
    }

    public void info(Object message) {
        SupplyLane<LogEntry> metaInfoLog = this.metaInfoLog;
        if (metaInfoLog != null) {
            metaInfoLog.push((Object)LogEntry.info(message));
        }
        this.node.info(message);
    }

    public void warn(Object message) {
        SupplyLane<LogEntry> metaWarnLog = this.metaWarnLog;
        if (metaWarnLog != null) {
            metaWarnLog.push((Object)LogEntry.warn(message));
        }
        this.node.warn(message);
    }

    public void error(Object message) {
        SupplyLane<LogEntry> metaErrorLog = this.metaErrorLog;
        if (metaErrorLog != null) {
            metaErrorLog.push((Object)LogEntry.error(message));
        }
        this.node.error(message);
    }

    public void fail(Object message) {
        SupplyLane<LogEntry> metaFailLog = this.metaFailLog;
        if (metaFailLog != null) {
            metaFailLog.push((Object)LogEntry.fail(message));
        }
        this.node.fail(message);
    }

    @Override
    public void close() {
        this.node.closeLane(this.laneAddress.laneUri());
    }

    @Override
    public void willOpen() {
        this.lane.open();
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
        this.lane.load();
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
        this.lane.start();
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
        this.lane.stop();
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
        this.lane.unload();
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
        this.lane.close();
    }
}

