/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Lane;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentFactory;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.SupplyLane;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.runtime.LaneBinding;
import swim.runtime.Metric;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.Push;
import swim.runtime.TierBinding;
import swim.runtime.agent.AgentModelDidClose;
import swim.runtime.agent.AgentModelDidLoad;
import swim.runtime.agent.AgentModelDidStart;
import swim.runtime.agent.AgentModelDidStop;
import swim.runtime.agent.AgentModelDidUnload;
import swim.runtime.agent.AgentModelLanesController;
import swim.runtime.agent.AgentModelPulseController;
import swim.runtime.agent.AgentModelPushUp;
import swim.runtime.agent.AgentModelWillClose;
import swim.runtime.agent.AgentModelWillLoad;
import swim.runtime.agent.AgentModelWillStart;
import swim.runtime.agent.AgentModelWillStop;
import swim.runtime.agent.AgentModelWillUnload;
import swim.runtime.agent.AgentNode;
import swim.runtime.agent.AgentView;
import swim.runtime.profile.NodeProfile;
import swim.runtime.profile.WarpDownlinkProfile;
import swim.runtime.profile.WarpLaneProfile;
import swim.runtime.reflect.AgentPulse;
import swim.runtime.reflect.LaneInfo;
import swim.runtime.reflect.LogEntry;
import swim.runtime.reflect.NodePulse;
import swim.runtime.reflect.WarpDownlinkPulse;
import swim.runtime.reflect.WarpUplinkPulse;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Builder;

public class AgentModel
extends AgentNode {
    protected final Value props;
    volatile Object views;
    volatile int agentOpenDelta;
    volatile int agentOpenCount;
    volatile int agentCloseDelta;
    volatile int agentCloseCount;
    volatile long agentExecDelta;
    volatile long agentExecRate;
    volatile long agentExecTime;
    volatile int timerEventDelta;
    volatile long timerEventCount;
    volatile int downlinkOpenDelta;
    volatile long downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile long downlinkCloseCount;
    volatile int downlinkEventDelta;
    volatile int downlinkEventRate;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile int downlinkCommandRate;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile long uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile long uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile int uplinkEventRate;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile int uplinkCommandRate;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;
    NodePulse pulse;
    AgentNode metaNode;
    DemandMapLane<Uri, LaneInfo> metaLanes;
    DemandLane<NodePulse> metaPulse;
    SupplyLane<LogEntry> metaTraceLog;
    SupplyLane<LogEntry> metaDebugLog;
    SupplyLane<LogEntry> metaInfoLog;
    SupplyLane<LogEntry> metaWarnLog;
    SupplyLane<LogEntry> metaErrorLog;
    SupplyLane<LogEntry> metaFailLog;
    static final AtomicReferenceFieldUpdater<AgentModel, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(AgentModel.class, Object.class, "views");
    static final AtomicIntegerFieldUpdater<AgentModel> AGENT_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "agentOpenDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> AGENT_OPEN_COUNT = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "agentOpenCount");
    static final AtomicIntegerFieldUpdater<AgentModel> AGENT_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "agentCloseDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> AGENT_CLOSE_COUNT = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "agentCloseCount");
    static final AtomicLongFieldUpdater<AgentModel> AGENT_EXEC_DELTA = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "agentExecDelta");
    static final AtomicLongFieldUpdater<AgentModel> AGENT_EXEC_RATE = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "agentExecRate");
    static final AtomicLongFieldUpdater<AgentModel> AGENT_EXEC_TIME = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "agentExecTime");
    static final AtomicIntegerFieldUpdater<AgentModel> TIMER_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "timerEventDelta");
    static final AtomicLongFieldUpdater<AgentModel> TIMER_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "timerEventCount");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkOpenDelta");
    static final AtomicLongFieldUpdater<AgentModel> DOWNLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "downlinkOpenCount");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkCloseDelta");
    static final AtomicLongFieldUpdater<AgentModel> DOWNLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "downlinkCloseCount");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkEventDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkEventRate");
    static final AtomicLongFieldUpdater<AgentModel> DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "downlinkEventCount");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkCommandDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> DOWNLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "downlinkCommandRate");
    static final AtomicLongFieldUpdater<AgentModel> DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "downlinkCommandCount");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkOpenDelta");
    static final AtomicLongFieldUpdater<AgentModel> UPLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "uplinkOpenCount");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkCloseDelta");
    static final AtomicLongFieldUpdater<AgentModel> UPLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "uplinkCloseCount");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkEventDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_EVENT_RATE = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkEventRate");
    static final AtomicLongFieldUpdater<AgentModel> UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "uplinkEventCount");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkCommandDelta");
    static final AtomicIntegerFieldUpdater<AgentModel> UPLINK_COMMAND_RATE = AtomicIntegerFieldUpdater.newUpdater(AgentModel.class, "uplinkCommandRate");
    static final AtomicLongFieldUpdater<AgentModel> UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "uplinkCommandCount");
    static final AtomicLongFieldUpdater<AgentModel> LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(AgentModel.class, "lastReportTime");

    public AgentModel(Value props) {
        this.props = props.commit();
    }

    @Override
    public void setNodeContext(NodeContext nodeContext) {
        super.setNodeContext(nodeContext);
    }

    public Value props() {
        return this.props;
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        if (metaNode instanceof AgentNode) {
            this.metaNode = (AgentNode)metaNode;
            this.openMetaLanes(node, (AgentNode)metaNode);
        }
        this.nodeContext.openMetaNode(node, metaNode);
    }

    protected void openMetaLanes(NodeBinding node, AgentNode metaNode) {
        this.openReflectLanes(node, metaNode);
        this.openLogLanes(node, metaNode);
    }

    protected void openReflectLanes(NodeBinding node, AgentNode metaNode) {
        this.metaLanes = metaNode.demandMapLane().keyForm(Uri.form()).valueForm(LaneInfo.form()).observe((Object)new AgentModelLanesController(node));
        metaNode.openLane(LANES_URI, (Lane)this.metaLanes);
        this.metaPulse = metaNode.demandLane().valueForm(NodePulse.form()).observe((Object)new AgentModelPulseController(this));
        metaNode.openLane(NodePulse.PULSE_URI, (Lane)this.metaPulse);
    }

    protected void openLogLanes(NodeBinding node, AgentNode metaNode) {
        this.metaTraceLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.TRACE_LOG_URI, (Lane)this.metaTraceLog);
        this.metaDebugLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.DEBUG_LOG_URI, (Lane)this.metaDebugLog);
        this.metaInfoLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.INFO_LOG_URI, (Lane)this.metaInfoLog);
        this.metaWarnLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.WARN_LOG_URI, (Lane)this.metaWarnLog);
        this.metaErrorLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.ERROR_LOG_URI, (Lane)this.metaErrorLog);
        this.metaFailLog = metaNode.supplyLane().valueForm(LogEntry.form());
        metaNode.openLane(LogEntry.FAIL_LOG_URI, (Lane)this.metaFailLog);
    }

    @Override
    public FingerTrieSeq<Value> agentIds() {
        Builder builder = FingerTrieSeq.builder();
        Object views = this.views;
        if (views instanceof AgentView) {
            builder.add((Object)((AgentView)views).id);
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                builder.add((Object)viewArray[i].id);
            }
        }
        return (FingerTrieSeq)builder.bind();
    }

    @Override
    public FingerTrieSeq<Agent> agents() {
        Builder builder = FingerTrieSeq.builder();
        Object views = this.views;
        if (views instanceof AgentView) {
            builder.add((Object)((AgentView)views).agent);
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                builder.add((Object)viewArray[i].agent);
            }
        }
        return (FingerTrieSeq)builder.bind();
    }

    public AgentView getAgentView(Value id) {
        Object views = this.views;
        if (views instanceof AgentView) {
            AgentView view = (AgentView)views;
            if (id.equals((Object)view.id)) {
                return view;
            }
        } else if (views instanceof AgentView[]) {
            for (AgentView view : (AgentView[])views) {
                if (!id.equals((Object)view.id)) continue;
                return view;
            }
        }
        return null;
    }

    public <S extends Agent> S getAgent(Class<S> agentClass) {
        Object views = this.views;
        if (views instanceof AgentView) {
            Agent agent = ((AgentView)views).agent;
            if (agentClass.isInstance(agent)) {
                return (S)agent;
            }
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Agent agent = viewArray[i].agent;
                if (!agentClass.isInstance(agent)) continue;
                return (S)agent;
            }
        }
        return null;
    }

    public AgentView addAgentView(AgentView view) {
        AgentView[] newViews;
        Object oldViews;
        do {
            AgentView oldView;
            if ((oldViews = this.views) instanceof AgentView) {
                oldView = (AgentView)oldViews;
                if (view.id.equals((Object)oldView.id)) {
                    return oldView;
                }
                newViews = new AgentView[]{oldView, view};
                continue;
            }
            if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = (AgentView[])oldViews;
                int n = oldViewArray.length;
                AgentView[] newViewArray = new AgentView[n + 1];
                for (int i = 0; i < n; ++i) {
                    oldView = oldViewArray[i];
                    if (view.id.equals((Object)oldView.id)) {
                        return oldView;
                    }
                    newViewArray[i] = oldViewArray[i];
                }
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.activate((TierBinding)view);
        this.didOpenAgent((AgentView)view);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentView createAgent(AgentFactory<?> agentFactory, Value id, Value props) {
        Agent agent;
        AgentView view = new AgentView(this, id, props);
        try {
            SwimContext.setAgentContext((AgentContext)view);
            agent = agentFactory.createAgent((AgentContext)view);
        }
        finally {
            SwimContext.clear();
        }
        view.setAgent(agent);
        return view;
    }

    public <S extends Agent> S openAgent(Value id, Value props, AgentFactory<S> agentFactory) {
        AgentView[] newViews;
        Object oldViews;
        Object view = null;
        do {
            AgentView oldView;
            if ((oldViews = this.views) instanceof AgentView) {
                oldView = (AgentView)oldViews;
                if (id.equals((Object)oldView.id)) {
                    return (S)oldView.agent;
                }
                if (view == null) {
                    view = this.createAgent(agentFactory, id, props);
                }
                newViews = new AgentView[]{oldView, view};
                continue;
            }
            if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = (AgentView[])oldViews;
                int n = oldViewArray.length;
                AgentView[] newViewArray = new AgentView[n + 1];
                for (int i = 0; i < n; ++i) {
                    oldView = oldViewArray[i];
                    if (id.equals((Object)oldView.id)) {
                        return (S)oldView.agent;
                    }
                    newViewArray[i] = oldViewArray[i];
                }
                if (view == null) {
                    view = this.createAgent(agentFactory, id, props);
                }
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            if (view == null) {
                view = this.createAgent(agentFactory, id, props);
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.activate((TierBinding)view);
        this.didOpenAgent((AgentView)view);
        return (S)view.agent;
    }

    public void removeAgentView(AgentView view) {
        AgentView[] newViews;
        AgentView[] oldViews;
        do {
            if ((oldViews = this.views) instanceof AgentView) {
                if (oldViews == view) {
                    newViews = null;
                    continue;
                }
            } else if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = oldViews;
                int n = oldViewArray.length;
                if (n == 2) {
                    if (oldViewArray[0] == view) {
                        newViews = oldViewArray[1];
                        continue;
                    }
                    if (oldViewArray[1] == view) {
                        newViews = oldViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    AgentView[] newViewArray = new AgentView[n - 1];
                    for (i = 0; i < n && oldViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newViewArray[i] = oldViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldViewArray, i + 1, newViewArray, i, n - (i + 1));
                        newViews = newViewArray;
                        continue;
                    }
                }
            }
            newViews = oldViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        if (oldViews != newViews) {
            this.didCloseAgentView(view);
        }
    }

    @Override
    protected void didOpenLane(LaneBinding lane) {
        DemandMapLane<Uri, LaneInfo> metaLanes = this.metaLanes;
        if (metaLanes != null) {
            metaLanes.cue((Object)lane.laneUri());
        }
    }

    @Override
    protected void didCloseLane(LaneBinding lane) {
        DemandMapLane<Uri, LaneInfo> metaLanes = this.metaLanes;
        if (metaLanes != null) {
            metaLanes.remove((Object)lane.laneUri());
        }
    }

    @Override
    public void pushUp(Push<?> push) {
        this.execute(new AgentModelPushUp(this, push));
    }

    @Override
    public void trace(Object message) {
        SupplyLane<LogEntry> metaTraceLog = this.metaTraceLog;
        if (metaTraceLog != null) {
            metaTraceLog.push((Object)LogEntry.trace(message));
        }
        super.trace(message);
    }

    @Override
    public void debug(Object message) {
        SupplyLane<LogEntry> metaDebugLog = this.metaDebugLog;
        if (metaDebugLog != null) {
            metaDebugLog.push((Object)LogEntry.debug(message));
        }
        super.debug(message);
    }

    @Override
    public void info(Object message) {
        SupplyLane<LogEntry> metaInfoLog = this.metaInfoLog;
        if (metaInfoLog != null) {
            metaInfoLog.push((Object)LogEntry.info(message));
        }
        super.info(message);
    }

    @Override
    public void warn(Object message) {
        SupplyLane<LogEntry> metaWarnLog = this.metaWarnLog;
        if (metaWarnLog != null) {
            metaWarnLog.push((Object)LogEntry.warn(message));
        }
        super.warn(message);
    }

    @Override
    public void error(Object message) {
        SupplyLane<LogEntry> metaErrorLog = this.metaErrorLog;
        if (metaErrorLog != null) {
            metaErrorLog.push((Object)LogEntry.error(message));
        }
        super.error(message);
    }

    @Override
    public void fail(Object message) {
        SupplyLane<LogEntry> metaFailLog = this.metaFailLog;
        if (metaFailLog != null) {
            metaFailLog.push((Object)LogEntry.fail(message));
        }
        super.fail(message);
    }

    protected void didOpenAgent(AgentView view) {
        AGENT_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didCloseAgentView(AgentView view) {
        AGENT_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Object views = this.views;
        if (views instanceof AgentView) {
            ((AgentView)views).willOpen();
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].willOpen();
            }
        }
    }

    @Override
    protected void didOpen() {
        super.didOpen();
        Object views = this.views;
        if (views instanceof AgentView) {
            ((AgentView)views).didOpen();
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].didOpen();
            }
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        this.execute(new AgentModelWillLoad(this));
    }

    @Override
    protected void didLoad() {
        super.didLoad();
        this.execute(new AgentModelDidLoad(this));
    }

    @Override
    protected void willStart() {
        super.willStart();
        this.execute(new AgentModelWillStart(this));
    }

    @Override
    protected void didStart() {
        super.didStart();
        this.execute(new AgentModelDidStart(this));
    }

    @Override
    protected void willStop() {
        super.willStop();
        this.execute(new AgentModelWillStop(this));
    }

    @Override
    protected void didStop() {
        super.didStop();
        this.execute(new AgentModelDidStop(this));
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        this.execute(new AgentModelWillUnload(this));
    }

    @Override
    protected void didUnload() {
        super.didUnload();
        this.execute(new AgentModelDidUnload(this));
    }

    @Override
    public void willClose() {
        super.willClose();
        this.execute(new AgentModelWillClose(this));
    }

    @Override
    public void didClose() {
        super.didClose();
        this.execute(new AgentModelDidClose(this));
        Object views = this.views;
        if (views instanceof AgentView) {
            AGENT_CLOSE_DELTA.incrementAndGet(this);
        } else if (views instanceof AgentView[]) {
            AGENT_CLOSE_DELTA.addAndGet(this, ((AgentView[])views).length);
        }
        AgentNode metaNode = this.metaNode;
        if (metaNode != null) {
            metaNode.close();
            this.metaNode = null;
            this.metaLanes = null;
            this.metaTraceLog = null;
            this.metaDebugLog = null;
            this.metaInfoLog = null;
            this.metaWarnLog = null;
            this.metaErrorLog = null;
            this.metaFailLog = null;
        }
        this.flushMetrics();
    }

    @Override
    public void didFail(Throwable error) {
        super.didFail(error);
        Object views = this.views;
        if (views instanceof AgentView) {
            try {
                ((AgentView)views).didFail(error);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cause.printStackTrace();
                }
                throw cause;
            }
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    viewArray[i].didFail(error);
                    continue;
                }
                catch (Throwable cause) {
                    if (Conts.isNonFatal((Throwable)cause)) {
                        cause.printStackTrace();
                        continue;
                    }
                    throw cause;
                }
            }
        }
    }

    @Override
    public void reportDown(Metric metric) {
        if (metric instanceof WarpLaneProfile) {
            this.accumulateWarpLaneProfile((WarpLaneProfile)metric);
        } else if (metric instanceof WarpDownlinkProfile) {
            this.accumulateWarpDownlinkProfile((WarpDownlinkProfile)metric);
        } else {
            super.reportDown(metric);
        }
    }

    public void accumulateExecTime(long agentExecDelta) {
        AGENT_EXEC_DELTA.addAndGet(this, agentExecDelta);
        this.didUpdateMetrics();
    }

    protected void accumulateWarpLaneProfile(WarpLaneProfile profile) {
        AGENT_EXEC_DELTA.addAndGet(this, profile.execDelta());
        AGENT_EXEC_RATE.addAndGet(this, profile.execRate());
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.downlinkOpenDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.downlinkCloseDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.downlinkEventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.downlinkEventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.downlinkCommandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.downlinkCommandRate());
        UPLINK_OPEN_DELTA.addAndGet(this, profile.uplinkOpenDelta());
        UPLINK_CLOSE_DELTA.addAndGet(this, profile.uplinkCloseDelta());
        UPLINK_EVENT_DELTA.addAndGet(this, profile.uplinkEventDelta());
        UPLINK_EVENT_RATE.addAndGet(this, profile.uplinkEventRate());
        UPLINK_COMMAND_DELTA.addAndGet(this, profile.uplinkCommandDelta());
        UPLINK_COMMAND_RATE.addAndGet(this, profile.uplinkCommandRate());
        this.didUpdateMetrics();
    }

    protected void accumulateWarpDownlinkProfile(WarpDownlinkProfile profile) {
        AGENT_EXEC_DELTA.addAndGet(this, profile.execDelta());
        AGENT_EXEC_RATE.addAndGet(this, profile.execRate());
        DOWNLINK_OPEN_DELTA.addAndGet(this, profile.openDelta());
        DOWNLINK_CLOSE_DELTA.addAndGet(this, profile.closeDelta());
        DOWNLINK_EVENT_DELTA.addAndGet(this, profile.eventDelta());
        DOWNLINK_EVENT_RATE.addAndGet(this, profile.eventRate());
        DOWNLINK_COMMAND_DELTA.addAndGet(this, profile.commandDelta());
        DOWNLINK_COMMAND_RATE.addAndGet(this, profile.commandRate());
        this.didUpdateMetrics();
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = this.lastReportTime)) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        NodeProfile profile = this.collectProfile(dt);
        this.nodeContext.reportDown(profile);
    }

    protected NodeProfile collectProfile(long dt) {
        int agentOpenDelta = AGENT_OPEN_DELTA.getAndSet(this, 0);
        int agentOpenCount = AGENT_OPEN_COUNT.addAndGet(this, agentOpenDelta);
        int agentCloseDelta = AGENT_CLOSE_DELTA.getAndSet(this, 0);
        int agentCloseCount = AGENT_CLOSE_COUNT.addAndGet(this, agentCloseDelta);
        long agentExecDelta = AGENT_EXEC_DELTA.getAndSet(this, 0L);
        long agentExecRate = AGENT_EXEC_RATE.getAndSet(this, 0L);
        long agentExecTime = AGENT_EXEC_TIME.addAndGet(this, agentExecDelta);
        int timerEventDelta = TIMER_EVENT_DELTA.getAndSet(this, 0);
        int timerEventRate = (int)Math.ceil(1000.0 * (double)timerEventDelta / (double)dt);
        long timerEventCount = TIMER_EVENT_COUNT.addAndGet(this, timerEventDelta);
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        long downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        long downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = DOWNLINK_EVENT_RATE.getAndSet(this, 0);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = DOWNLINK_COMMAND_RATE.getAndSet(this, 0);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        long uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        long uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = UPLINK_EVENT_RATE.getAndSet(this, 0);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0);
        int uplinkCommandRate = UPLINK_COMMAND_RATE.getAndSet(this, 0);
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        long agentCount = agentOpenCount - agentCloseCount;
        AgentPulse agentPulse = new AgentPulse(agentCount, agentExecRate, agentExecTime, timerEventRate, timerEventCount);
        long downlinkCount = downlinkOpenCount - downlinkCloseCount;
        WarpDownlinkPulse downlinkPulse = new WarpDownlinkPulse(downlinkCount, downlinkEventRate, downlinkEventCount, downlinkCommandRate, downlinkCommandCount);
        long uplinkCount = uplinkOpenCount - uplinkCloseCount;
        WarpUplinkPulse uplinkPulse = new WarpUplinkPulse(uplinkCount, uplinkEventRate, uplinkEventCount, uplinkCommandRate, uplinkCommandCount);
        this.pulse = new NodePulse(agentPulse, downlinkPulse, uplinkPulse);
        DemandLane<NodePulse> metaPulse = this.metaPulse;
        if (metaPulse != null) {
            metaPulse.cue();
        }
        return new NodeProfile(this.cellAddress(), agentOpenDelta, agentOpenCount, agentCloseDelta, agentCloseCount, agentExecDelta, agentExecRate, agentExecTime, timerEventDelta, timerEventRate, timerEventCount, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }
}

