/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.DownlinkRelay;
import swim.runtime.downlink.MapDownlinkModel;
import swim.runtime.downlink.MapDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.EventMessage;

final class MapDownlinkRelayUpdate
extends DownlinkRelay<MapDownlinkModel, MapDownlinkView<?, ?>> {
    final EventMessage message;
    final Cont<EventMessage> cont;
    final Value key;
    Form<Object> keyForm;
    Form<Object> valueForm;
    Object keyObject;
    Value oldValue;
    Value newValue;
    Object oldObject;
    Object newObject;

    MapDownlinkRelayUpdate(MapDownlinkModel model, EventMessage message, Cont<EventMessage> cont, Value key, Value newValue) {
        super(model, 4);
        this.message = message;
        this.cont = cont;
        this.key = key;
        this.newValue = newValue;
    }

    MapDownlinkRelayUpdate(MapDownlinkModel model, Stage stage, Value key, Value newValue) {
        super(model, 1, 3, stage);
        this.message = null;
        this.cont = null;
        this.key = key;
        this.newValue = newValue;
        this.stage = stage;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            if (((MapDownlinkModel)this.model).isStateful()) {
                this.oldValue = (Value)((MapDownlinkModel)this.model).state.put((Object)this.key, (Object)this.newValue);
            }
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
        }
    }

    @Override
    protected boolean runPhase(MapDownlinkView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Map.Entry<Boolean, Object> result;
            Form valueForm;
            this.newValue = view.downlinkWillUpdateValue(this.key, this.newValue);
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                if (this.oldValue != null) {
                    this.oldObject = valueForm.cast((Item)this.oldValue);
                }
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
            }
            if (preemptive) {
                this.newObject = view.downlinkWillUpdate(this.keyObject, this.newObject);
            }
            if (this.newObject != (result = view.dispatchWillUpdate(this.keyObject, this.newObject, preemptive)).getValue()) {
                this.oldObject = this.newObject;
                this.newObject = result.getValue();
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            view.downlinkDidUpdateValue(this.key, this.newValue, this.oldValue);
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidUpdate(this.keyObject, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.keyObject, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        if (this.message != null) {
            ((MapDownlinkModel)this.model).cueDown();
        } else {
            ((MapDownlinkModel)this.model).cueUpKey(this.key);
        }
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

