/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Lane;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.lane.CommandLane;
import swim.api.warp.function.DidCommand;
import swim.api.warp.function.DidEnter;
import swim.api.warp.function.DidLeave;
import swim.api.warp.function.DidUplink;
import swim.api.warp.function.OnCommand;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillEnter;
import swim.api.warp.function.WillLeave;
import swim.api.warp.function.WillUplink;
import swim.concurrent.Conts;
import swim.runtime.lane.CommandLaneModel;
import swim.runtime.warp.WarpLaneView;
import swim.structure.Form;

public class CommandLaneView<V>
extends WarpLaneView
implements CommandLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected CommandLaneModel laneBinding;

    public CommandLaneView(AgentContext agentContext, Form<V> valueForm, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
    }

    public CommandLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public CommandLaneModel laneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(CommandLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public CommandLaneModel createLaneBinding() {
        return new CommandLaneModel();
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> CommandLaneView<V2> valueForm(Form<V2> valueForm) {
        return new CommandLaneView<V2>(this.agentContext, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> CommandLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public CommandLaneView<V> observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public CommandLaneView<V> unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public CommandLaneView<V> onCommand(OnCommand<V> onCommand) {
        return this.observe(onCommand);
    }

    @Override
    public CommandLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public CommandLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public CommandLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public CommandLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public CommandLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public CommandLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public CommandLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public CommandLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    public void laneOnCommand(V value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchOnCommand(Link link, V value, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof OnCommand) {
                if (((OnCommand)observers).isPreemptive() == preemptive) {
                    try {
                        ((OnCommand)observers).onCommand(value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof OnCommand)) continue;
                    if (((OnCommand)observer).isPreemptive() == preemptive) {
                        try {
                            ((OnCommand)observer).onCommand(value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }
}

