/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.downlink.MapDownlink;
import swim.runtime.LaneRelay;
import swim.runtime.lane.JoinMapLaneDownlink;
import swim.runtime.lane.JoinMapLaneModel;
import swim.runtime.lane.JoinMapLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class JoinMapLaneRelayDownlink
extends LaneRelay<JoinMapLaneModel, JoinMapLaneView<?, ?, ?>> {
    final Value key;
    Form<Object> keyForm;
    Object keyObject;
    JoinMapLaneDownlink<Object, Object> downlink;

    JoinMapLaneRelayDownlink(JoinMapLaneModel model, Value key, JoinMapLaneDownlink<?, ?> downlink) {
        super(model, 2);
        this.key = key;
        this.downlink = downlink;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 1) {
            ((JoinMapLaneModel)this.model).openDownlink(this.key, this.downlink);
        }
    }

    @Override
    protected boolean runPhase(JoinMapLaneView<?, ?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (preemptive) {
                this.downlink = (JoinMapLaneDownlink)view.laneWillDownlink(this.keyObject, this.downlink);
            }
            Map.Entry<Boolean, MapDownlink<Object, Object>> result = view.dispatchWillDownlink(this.keyObject, this.downlink, preemptive);
            this.downlink = (JoinMapLaneDownlink)result.getValue();
            return result.getKey();
        }
        if (phase == 1) {
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidDownlink(this.keyObject, this.downlink);
            }
            return view.dispatchDidDownlink(this.keyObject, this.downlink, preemptive);
        }
        throw new AssertionError();
    }
}

