/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.JoinValueLaneDownlink;
import swim.runtime.lane.JoinValueLaneModel;
import swim.runtime.lane.JoinValueLaneView;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class JoinValueLaneRelayUpdate
extends LaneRelay<JoinValueLaneModel, JoinValueLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;
    final Value key;
    Form<Object> keyForm;
    Form<Object> valueForm;
    Object keyObject;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    JoinValueLaneRelayUpdate(JoinValueLaneModel model, CommandMessage message, Cont<CommandMessage> cont, Value key, Value newValue) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
        this.key = key;
        this.newValue = newValue;
    }

    JoinValueLaneRelayUpdate(JoinValueLaneModel model, Link link, Value key, Value newValue) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.newValue = newValue;
    }

    JoinValueLaneRelayUpdate(JoinValueLaneModel model, Stage stage, Value key, Value newValue) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            JoinValueLaneDownlink<?> downlink;
            Item head = ((Value)((JoinValueLaneModel)this.model).data.get((Object)this.key)).head();
            Value dataValue = this.newValue;
            if (head instanceof Attr && "downlink".equals(((Attr)head).name())) {
                dataValue = head.concat((Item)dataValue);
            }
            this.oldValue = (Value)((JoinValueLaneModel)this.model).data.put((Object)this.key, (Object)dataValue);
            if ("downlink".equals(this.oldValue.tag())) {
                this.oldValue = this.oldValue.body();
            }
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
            if (this.message != null && (downlink = ((JoinValueLaneModel)this.model).getDownlink(this.key)) != null) {
                downlink.setValue(this.newValue);
            }
        }
    }

    @Override
    protected boolean runPhase(JoinValueLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillUpdate(this.keyObject, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.link, this.keyObject, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidUpdate(this.keyObject, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.link, this.keyObject, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((JoinValueLaneModel)this.model).cueDownKey(this.key);
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

