/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.runtime.warp.ListLinkDelta;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ListLaneRelayUpdate
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;
    final int index;
    Object key;
    Form<Object> valueForm;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    ListLaneRelayUpdate(ListLaneModel model, CommandMessage message, Cont<CommandMessage> cont, int index, Value newValue, Object key) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
        this.index = index;
        this.newValue = newValue;
        this.key = key;
    }

    ListLaneRelayUpdate(ListLaneModel model, Link link, int index, Value newValue, Object key) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
        this.index = index;
        this.newValue = newValue;
        this.key = key;
    }

    ListLaneRelayUpdate(ListLaneModel model, Stage stage, int index, Value newValue, Object key) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
        this.index = index;
        this.newValue = newValue;
        this.key = key;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            Map.Entry entry = ((ListLaneModel)this.model).data.isEmpty() ? null : ((ListLaneModel)this.model).data.getEntry(this.index, this.key);
            if (entry == null) {
                if (this.key == null) {
                    byte[] bytes = new byte[6];
                    ThreadLocalRandom.current().nextBytes(bytes);
                    this.key = Value.fromObject((Object)bytes);
                }
                ((ListLaneModel)this.model).data.add(this.index, (Object)this.newValue, this.key);
            } else {
                this.oldValue = (Value)entry.getValue();
                this.key = entry.getKey();
                ((ListLaneModel)this.model).data.set(this.index, (Object)this.newValue, this.key);
            }
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    protected boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillUpdate(this.index, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.link, this.index, this.newObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidUpdate(this.index, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.link, this.index, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((ListLaneModel)this.model).sendDown(ListLinkDelta.update(this.index, Value.fromObject((Object)this.key), this.newValue));
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

