/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.api.LaneException;
import swim.api.data.MapData;
import swim.collections.FingerTrieSeq;
import swim.runtime.LaneView;
import swim.runtime.Push;
import swim.runtime.WarpBinding;
import swim.runtime.lane.MapLaneRelayClear;
import swim.runtime.lane.MapLaneRelayDrop;
import swim.runtime.lane.MapLaneRelayRemove;
import swim.runtime.lane.MapLaneRelayTake;
import swim.runtime.lane.MapLaneRelayUpdate;
import swim.runtime.lane.MapLaneUplink;
import swim.runtime.lane.MapLaneView;
import swim.runtime.warp.WarpLaneModel;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class MapLaneModel
extends WarpLaneModel<MapLaneView<?, ?>, MapLaneUplink> {
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;
    protected int flags;
    protected MapData<Value, Value> data;

    MapLaneModel(int flags) {
        this.flags = flags;
    }

    public MapLaneModel() {
        this(0);
    }

    @Override
    public String laneType() {
        return "map";
    }

    @Override
    protected MapLaneUplink createWarpUplink(WarpBinding link) {
        return new MapLaneUplink(this, link, this.createUplinkAddress(link));
    }

    @Override
    protected void didOpenLaneView(MapLaneView<?, ?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(Push<CommandMessage> push) {
        CommandMessage message = push.message();
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Value value = payload.body();
            new MapLaneRelayUpdate(this, message, push.cont(), key, value).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            new MapLaneRelayRemove(this, message, push.cont(), key).run();
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new MapLaneRelayDrop(this, message, push.cont(), lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new MapLaneRelayTake(this, message, push.cont(), upper).run();
        } else if ("clear".equals(tag)) {
            new MapLaneRelayClear(this, message, push.cont()).run();
        } else {
            push.trap((Throwable)new LaneException("unknown subcommand: " + payload));
        }
    }

    protected void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((MapLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public MapLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof MapLaneView) {
            ((MapLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((MapLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public MapLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof MapLaneView) {
            ((MapLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((MapLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public Value get(Value key) {
        if (key != null) {
            return (Value)this.data.get((Object)key);
        }
        return Value.absent();
    }

    public <K, V> V put(MapLaneView<K, V> view, K keyObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        MapLaneRelayUpdate relay = new MapLaneRelayUpdate(this, this.stage(), key, newValue);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public <K, V> V remove(MapLaneView<K, V> view, K keyObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        MapLaneRelayRemove relay = new MapLaneRelayRemove(this, this.stage(), key);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.run();
        if (relay.valueForm == valueForm || valueForm == null) {
            return (V)relay.oldObject;
        }
        return (V)valueForm.unit();
    }

    public void drop(MapLaneView<?, ?> view, int lower) {
        if (lower > 0) {
            MapLaneRelayDrop relay = new MapLaneRelayDrop(this, this.stage(), lower);
            relay.run();
        }
    }

    public void take(MapLaneView<?, ?> view, int upper) {
        if (upper > 0) {
            MapLaneRelayTake relay = new MapLaneRelayTake(this, this.stage(), upper);
            relay.run();
        }
    }

    public void clear(MapLaneView<?, ?> view) {
        MapLaneRelayClear relay = new MapLaneRelayClear(this, this.stage());
        relay.run();
    }

    public Iterator<Map.Entry<Value, Value>> iterator() {
        return this.data.iterator();
    }

    public Iterator<Value> keyIterator() {
        return this.data.keyIterator();
    }

    public Iterator<Value> valueIterator() {
        return this.data.valueIterator();
    }

    protected void openStore() {
        this.data = this.laneContext.store().mapData(this.laneUri().toString()).isTransient(this.isTransient()).isResident(this.isResident());
    }

    @Override
    protected void willLoad() {
        this.openStore();
        super.willLoad();
    }
}

