/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.LaneRelay;
import swim.runtime.lane.SpatialLaneModel;
import swim.runtime.lane.SpatialLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class SpatialLaneRelayMove<S>
extends LaneRelay<SpatialLaneModel<S>, SpatialLaneView<?, S, ?>> {
    final Link link;
    final CommandMessage message;
    final Cont<CommandMessage> cont;
    final Value key;
    final S oldShapeObject;
    final S newShapeObject;
    Form<Object> keyForm;
    Z2Form<Object> shapeForm;
    Form<Object> valueForm;
    Object keyObject;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    SpatialLaneRelayMove(SpatialLaneModel<S> model, CommandMessage message, Cont<CommandMessage> cont, Value key, S oldShapeObject, S newShapeObject, Value newValue) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.cont = cont;
        this.key = key;
        this.oldShapeObject = oldShapeObject;
        this.newShapeObject = newShapeObject;
        this.newValue = newValue;
    }

    SpatialLaneRelayMove(SpatialLaneModel<S> model, Link link, Value key, S oldShapeObject, S newShapeObject, Value newValue) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.oldShapeObject = oldShapeObject;
        this.newShapeObject = newShapeObject;
        this.newValue = newValue;
    }

    SpatialLaneRelayMove(SpatialLaneModel<S> model, Stage stage, Value key, S oldShapeObject, S newShapeObject, Value newValue) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.cont = null;
        this.key = key;
        this.oldShapeObject = oldShapeObject;
        this.newShapeObject = newShapeObject;
        this.newValue = newValue;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((SpatialLaneModel)this.model).data.move((Object)this.key, this.oldShapeObject, this.newShapeObject, (Object)this.newValue);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    protected boolean runPhase(SpatialLaneView<?, S, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillMove(this.keyObject, this.newShapeObject, this.oldObject, this.oldShapeObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillMove(this.link, this.keyObject, this.newShapeObject, this.oldObject, this.oldShapeObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.oldValue = this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidMove(this.keyObject, this.newShapeObject, this.newObject, this.oldShapeObject, this.oldObject);
            }
            return view.dispatchDidMove(this.link, this.keyObject, this.newShapeObject, this.newObject, this.oldShapeObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        Record header = Record.create((int)3).slot("key", this.key).slot("from", this.shapeForm.mold(this.oldShapeObject).toValue()).slot("to", this.shapeForm.mold(this.newShapeObject).toValue());
        ((SpatialLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("move", (Value)header));
        if (this.cont != null) {
            try {
                this.cont.bind((Object)this.message);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.cont.trap(error);
                }
                throw error;
            }
        }
    }
}

